/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TraverseUIStarter
implements ApplicationStarter {
    private static final String OPTIONS = "options";
    private static final String CONFIGURABLE = "configurable";
    private static final String ID = "id";
    private static final String CONFIGURABLE_NAME = "configurable_name";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String HIT = "hit";
    private static final String ROOT_ACTION_MODULE = "intellij.platform.ide";
    private String OUTPUT_PATH;
    private boolean SPLIT_BY_RESOURCE_PATH;

    public String getCommandName() {
        return "traverseUI";
    }

    public void premain(@NotNull List<String> args) {
        this.OUTPUT_PATH = args.get(1);
        this.SPLIT_BY_RESOURCE_PATH = args.size() > 2 && Boolean.parseBoolean(args.get(2));
    }

    public void main(@NotNull List<String> args) {
        System.out.println("Starting searchable options index builder");
        try {
            TraverseUIStarter.startup(this.OUTPUT_PATH, this.SPLIT_BY_RESOURCE_PATH);
            ((ApplicationEx)ApplicationManager.getApplication()).exit(3);
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(@NotNull String outputPath, boolean splitByResourcePath) throws IOException {
        LinkedHashMap<SearchableConfigurable, Set<OptionDescription>> options2 = new LinkedHashMap<SearchableConfigurable, Set<OptionDescription>>();
        try {
            Iterator extension2;
            for (Iterator extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.beforeStart();
            }
            SearchUtil.processProjectConfigurables(ProjectManager.getInstance().getDefaultProject(), options2);
            for (Iterator extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.afterTraversal(options2);
            }
            HashMap<String, Element> roots = new HashMap<String, Element>();
            extension2 = options2.keySet().iterator();
            while (extension2.hasNext()) {
                Element entryElement;
                Map.Entry entry;
                Object wrapped;
                SearchableConfigurable option2;
                SearchableConfigurable configurable2 = option2 = (SearchableConfigurable)extension2.next();
                Element configurableElement = TraverseUIStarter.createConfigurableElement(configurable2);
                Set sortedOptions = (Set)options2.get(configurable2);
                TraverseUIStarter.writeOptions(configurableElement, sortedOptions);
                if (configurable2 instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable2).getConfigurable()) instanceof SearchableConfigurable) {
                    configurable2 = (SearchableConfigurable)wrapped;
                }
                if (configurable2 instanceof KeymapPanel) {
                    wrapped = TraverseUIStarter.processKeymap(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                } else if (configurable2 instanceof OptionsContainingConfigurable) {
                    TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable2, configurableElement);
                } else if (configurable2 instanceof PluginManagerConfigurable) {
                    wrapped = TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0]))).iterator();
                    while (wrapped.hasNext()) {
                        OptionDescription description = (OptionDescription)wrapped.next();
                        TraverseUIStarter.append(null, IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0]), description.getOption(), configurableElement);
                    }
                } else if (configurable2 instanceof AllFileTemplatesConfigurable) {
                    wrapped = TraverseUIStarter.processFileTemplates(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                }
                String module = splitByResourcePath ? TraverseUIStarter.getModuleByClass(configurable2.getOriginalClass()) : "";
                TraverseUIStarter.addElement(roots, configurableElement, module);
            }
            for (Map.Entry entry : roots.entrySet()) {
                String module = (String)entry.getKey();
                String directory = module.isEmpty() ? "" : module + "/search/";
                String filePrefix = module.isEmpty() ? "" : module + ".";
                File output = new File(outputPath, directory + filePrefix + "searchableOptions.xml");
                FileUtil.ensureCanCreateFile((File)output);
                JDOMUtil.writeDocument((Document)new Document((Element)entry.getValue()), (File)output, (String)"\n");
            }
            for (TraverseUIHelper extension3 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension3.afterResultsAreSaved();
            }
            System.out.println("Searchable options index builder completed");
        }
        finally {
            for (SearchableConfigurable configurable3 : options2.keySet()) {
                configurable3.disposeUIResources();
            }
        }
    }

    @NotNull
    private static Element createConfigurableElement(@NotNull SearchableConfigurable configurable2) {
        Element configurableElement = new Element(CONFIGURABLE);
        String id2 = configurable2.getId();
        configurableElement.setAttribute(ID, id2);
        configurableElement.setAttribute(CONFIGURABLE_NAME, configurable2.getDisplayName());
        return configurableElement;
    }

    private static void addElement(@NotNull Map<String, Element> roots, @NotNull Element element2, @NotNull String module) {
        roots.computeIfAbsent(module, __ -> new Element(OPTIONS)).addContent(element2);
    }

    private static Map<String, Set<OptionDescription>> processFileTemplates(boolean splitByResourcePath) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        HashMap<String, Set<OptionDescription>> options2 = new HashMap<String, Set<OptionDescription>>();
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllPatterns(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllCodeTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllJ2eeTemplates(), splitByResourcePath);
        return options2;
    }

    private static void processTemplates(SearchableOptionsRegistrar registrar, Map<String, Set<OptionDescription>> options2, FileTemplate[] templates, boolean splitByResourcePath) {
        for (FileTemplate template : templates) {
            String module = splitByResourcePath && template instanceof BundledFileTemplate ? TraverseUIStarter.getModuleByTemplate((BundledFileTemplate)template) : "";
            TraverseUIStarter.collectOptions(registrar, options2.computeIfAbsent(module, __ -> new TreeSet()), template.getName(), null);
        }
    }

    @NotNull
    private static String getModuleByTemplate(@NotNull BundledFileTemplate template) {
        String url = template.toString();
        String path = StringUtil.substringBefore((String)url, (String)"fileTemplates");
        assert (path != null) : "Template URL doesn't contain 'fileTemplates' directory.";
        if (path.startsWith("jar")) {
            path = (String)URLUtil.splitJarUrl((String)path).first;
        }
        return TraverseUIStarter.getModuleByPath(path);
    }

    private static void collectOptions(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options2, @NotNull String text, String path) {
        for (String word : registrar.getProcessedWordsWithoutStemming(text)) {
            options2.add((OptionDescription)new OptionDescription(word, text, path));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable2, Element configurableElement) {
        Set<String> optionsPath = configurable2.processListOptions();
        Set<OptionDescription> result2 = TraverseUIStarter.wordsToOptionDescriptors(optionsPath);
        Map<String, Set<String>> optionsWithPaths = configurable2.processListOptionsWithPaths();
        for (String path : optionsWithPaths.keySet()) {
            result2.addAll(TraverseUIStarter.wordsToOptionDescriptors(optionsWithPaths.get(path), path));
        }
        TraverseUIStarter.writeOptions(configurableElement, result2);
    }

    private static Set<OptionDescription> wordsToOptionDescriptors(@NotNull Set<String> optionsPath) {
        return TraverseUIStarter.wordsToOptionDescriptors(optionsPath, null);
    }

    private static Set<OptionDescription> wordsToOptionDescriptors(@NotNull Set<String> optionsPath, @Nullable String path) {
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        TreeSet<OptionDescription> result2 = new TreeSet<OptionDescription>();
        for (String opt : optionsPath) {
            for (String word : registrar.getProcessedWordsWithoutStemming(opt)) {
                if (word == null) continue;
                result2.add(new OptionDescription(word, opt, path));
            }
        }
        return result2;
    }

    @NotNull
    private static Map<String, Set<OptionDescription>> processKeymap(boolean splitByResourcePath) {
        HashMap<String, Set<OptionDescription>> map2 = new HashMap<String, Set<OptionDescription>>();
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManager.getInstance();
        Map<String, Object> actionToPluginId = splitByResourcePath ? TraverseUIStarter.getActionToPluginId() : Collections.emptyMap();
        String componentName = "ActionManager";
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (String id2 : actionManager.getActionIds()) {
            String description;
            AnAction action2 = actionManager.getAction(id2);
            if (action2 == null) {
                throw new IllegalStateException("Cannot find action by id " + id2);
            }
            String module = splitByResourcePath ? TraverseUIStarter.getModuleByAction(action2, actionToPluginId) : "";
            Set options2 = map2.computeIfAbsent(module, __ -> new TreeSet());
            String text = action2.getTemplatePresentation().getText();
            if (text != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, text, componentName);
            }
            if ((description = action2.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, description, componentName);
        }
        return map2;
    }

    @NotNull
    private static Map<String, PluginId> getActionToPluginId() {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        HashMap<String, PluginId> actionToPluginId = new HashMap<String, PluginId>();
        for (PluginId id2 : PluginId.getRegisteredIdList()) {
            for (String action2 : actionManager.getPluginActions(id2)) {
                actionToPluginId.put(action2, id2);
            }
        }
        return actionToPluginId;
    }

    @NotNull
    private static String getModuleByAction(@NotNull AnAction rootAction, @NotNull Map<String, PluginId> actionToPluginId) {
        IdeaPluginDescriptor plugin;
        ArrayDeque<AnAction> actions = new ArrayDeque<AnAction>();
        actions.add(rootAction);
        while (!actions.isEmpty()) {
            AnAction action2 = (AnAction)actions.remove();
            String module = TraverseUIStarter.getModuleByClass(action2.getClass());
            if (!ROOT_ACTION_MODULE.equals(module)) {
                return module;
            }
            if (!(action2 instanceof ActionGroup)) continue;
            Collections.addAll(actions, ((ActionGroup)action2).getChildren(null));
        }
        ActionManager actionManager = ActionManager.getInstance();
        PluginId id2 = actionToPluginId.get(actionManager.getId(rootAction));
        if (id2 != null && (plugin = PluginManagerCore.getPlugin(id2)) != null && !plugin.getName().equals("IDEA CORE")) {
            return PathUtil.getFileName((String)plugin.getPluginPath().toString());
        }
        return ROOT_ACTION_MODULE;
    }

    @NotNull
    private static String getModuleByPath(@NotNull String path) {
        String relative;
        String homePath;
        if (new File(path).isFile() && FileUtil.isAncestor((String)(homePath = PathManager.getHomePath()), (String)path, (boolean)true) && (relative = FileUtil.getRelativePath((String)homePath, (String)path, (char)File.separatorChar)) != null) {
            return relative.replaceAll(File.separator, ".");
        }
        return PathUtil.getFileName((String)path);
    }

    @NotNull
    private static String getModuleByClass(@NotNull Class<?> aClass) {
        return TraverseUIStarter.getModuleByPath(PathUtil.getJarPathForClass(aClass));
    }

    private static void writeOptions(Element configurableElement, Set<? extends OptionDescription> options2) {
        for (OptionDescription optionDescription : options2) {
            TraverseUIStarter.append(optionDescription.getPath(), optionDescription.getHit(), optionDescription.getOption(), configurableElement);
        }
    }

    private static void append(String path, String hit, String word, Element configurableElement) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        configurableElement.addContent(optionElement);
    }
}

