/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeModelWrapper
implements StructureViewModel,
ProvidingTreeModel {
    private final StructureViewModel myModel;
    private final TreeActionsOwner myStructureView;

    public TreeModelWrapper(@NotNull StructureViewModel model, @NotNull TreeActionsOwner structureView) {
        this.myModel = model;
        this.myStructureView = structureView;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return this.myModel.getRoot();
    }

    public Grouper @NotNull [] getGroupers() {
        List filtered2 = this.filterActive((TreeAction[])this.myModel.getGroupers());
        return filtered2.toArray(Grouper.EMPTY_ARRAY);
    }

    @NotNull
    private <T extends TreeAction> List<T> filterActive(T @NotNull [] actions) {
        ArrayList<T> filtered2 = new ArrayList<T>();
        for (T action2 : actions) {
            if (!this.isFiltered((TreeAction)action2)) continue;
            filtered2.add(action2);
        }
        return filtered2;
    }

    @NotNull
    private List<NodeProvider> filterProviders(@NotNull Collection<? extends NodeProvider> actions) {
        ArrayList<NodeProvider> filtered2 = new ArrayList<NodeProvider>();
        for (NodeProvider nodeProvider : actions) {
            if (!this.isFiltered((TreeAction)nodeProvider)) continue;
            filtered2.add(nodeProvider);
        }
        return filtered2;
    }

    private boolean isFiltered(@NotNull TreeAction action2) {
        return action2 instanceof Sorter && !((Sorter)action2).isVisible() || this.myStructureView.isActionActive(action2.getName());
    }

    public Sorter @NotNull [] getSorters() {
        List filtered2 = this.filterActive((TreeAction[])this.myModel.getSorters());
        return filtered2.toArray(Sorter.EMPTY_ARRAY);
    }

    public Filter @NotNull [] getFilters() {
        List filtered2 = this.filterActive((TreeAction[])this.myModel.getFilters());
        return filtered2.toArray(Filter.EMPTY_ARRAY);
    }

    public Object getCurrentEditorElement() {
        return this.myModel.getCurrentEditorElement();
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        if (this.myModel instanceof ProvidingTreeModel) {
            return this.filterProviders(((ProvidingTreeModel)this.myModel).getNodeProviders());
        }
        return Collections.emptyList();
    }

    public static boolean isActive(@NotNull TreeAction action2, @NotNull TreeActionsOwner actionsOwner) {
        if (TreeModelWrapper.shouldRevert(action2)) {
            return !actionsOwner.isActionActive(action2.getName());
        }
        return action2 instanceof Sorter && !((Sorter)action2).isVisible() || actionsOwner.isActionActive(action2.getName());
    }

    public static boolean shouldRevert(@NotNull TreeAction action2) {
        return action2 instanceof Filter && ((Filter)action2).isReverted();
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myModel.addEditorPositionListener(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myModel.removeEditorPositionListener(listener2);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myModel);
    }

    public boolean shouldEnterElement(Object element2) {
        return false;
    }

    public void addModelListener(@NotNull ModelListener modelListener2) {
        this.myModel.addModelListener(modelListener2);
    }

    public void removeModelListener(@NotNull ModelListener modelListener2) {
        this.myModel.removeModelListener(modelListener2);
    }

    public StructureViewModel getModel() {
        return this.myModel;
    }

    public boolean isEnabled(@NotNull NodeProvider provider) {
        return this.myStructureView.isActionActive(provider.getName());
    }
}

