/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="StructureViewFactory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class StructureViewFactoryImpl
extends StructureViewFactoryEx
implements PersistentStateComponent<State> {
    private static final ExtensionPointName<StructureViewExtension> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.lang.structureViewExtension");
    private final Project myProject;
    private StructureViewWrapperImpl myStructureViewWrapperImpl;
    private State myState = new State();
    private Runnable myRunWhenInitialized = null;
    private final Map<Class<? extends PsiElement>, Collection<StructureViewExtension>> myImplExtensions = new ConcurrentHashMap<Class<? extends PsiElement>, Collection<StructureViewExtension>>();

    public StructureViewFactoryImpl(@NotNull Project project) {
        this.myProject = project;
        EXTENSION_POINT_NAME.addChangeListener(() -> {
            this.myImplExtensions.clear();
            if (this.myStructureViewWrapperImpl != null) {
                this.myStructureViewWrapperImpl.rebuild();
            }
        }, (Disposable)project);
    }

    @Override
    public StructureViewWrapper getStructureViewWrapper() {
        return this.myStructureViewWrapperImpl;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        this.myStructureViewWrapperImpl = new StructureViewWrapperImpl(this.myProject, toolWindow);
        if (this.myRunWhenInitialized != null) {
            this.myRunWhenInitialized.run();
            this.myRunWhenInitialized = null;
        }
    }

    @Override
    @NotNull
    public Collection<StructureViewExtension> getAllExtensions(@NotNull Class<? extends PsiElement> type) {
        Collection<StructureViewExtension> result2 = this.myImplExtensions.get(type);
        if (result2 != null) {
            return result2;
        }
        ExtensionPointImpl point = (ExtensionPointImpl)EXTENSION_POINT_NAME.getPoint();
        HashSet<Class<? extends PsiElement>> visitedTypes = new HashSet<Class<? extends PsiElement>>();
        result2 = new ArrayList<StructureViewExtension>();
        for (StructureViewExtension extension : point.getExtensionList()) {
            Class<? extends PsiElement> registeredType = extension.getType();
            if (!ReflectionUtil.isAssignable(registeredType, type) || !visitedTypes.add(registeredType)) continue;
            result2.addAll(ExtensionProcessingHelper.getByGroupingKey((ExtensionPointImpl)point, StructureViewExtension.class, registeredType, StructureViewExtension::getType));
        }
        Collection<StructureViewExtension> oldValue = this.myImplExtensions.putIfAbsent(type, result2);
        return oldValue == null ? result2 : oldValue;
    }

    @Override
    public void setActiveAction(String name, boolean state) {
        Collection<String> activeActions = this.collectActiveActions();
        if (state) {
            activeActions.add(name);
        } else {
            activeActions.remove(name);
        }
        this.myState.ACTIVE_ACTIONS = StructureViewFactoryImpl.toString(activeActions);
    }

    private static String toString(Collection<String> activeActions) {
        return StringUtil.join(activeActions, (String)",");
    }

    @NotNull
    public Collection<String> collectActiveActions() {
        return new LinkedHashSet<String>(Arrays.asList(this.myState.ACTIVE_ACTIONS.split(",")));
    }

    @Override
    public boolean isActionActive(String name) {
        return this.collectActiveActions().contains(name);
    }

    @Override
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (this.myStructureViewWrapperImpl != null) {
            runnable2.run();
        } else {
            this.myRunWhenInitialized = runnable2;
        }
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project) {
        return this.createStructureView(fileEditor, treeModel, project, true);
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project, boolean showRootNode) {
        return new StructureViewComponent(fileEditor, treeModel, project, showRootNode);
    }

    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myState = new State();
    }

    public static final class State {
        public boolean AUTOSCROLL_MODE = true;
        public boolean AUTOSCROLL_FROM_SOURCE = false;
        public String ACTIVE_ACTIONS = "";
    }
}

