/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionTreeElement
implements StructureViewTreeElement {
    private final PsiElement myStartElement;
    private int myEndOffset = Integer.MAX_VALUE;
    private final Collection<StructureViewTreeElement> myChildElements = new ArrayList<StructureViewTreeElement>();
    private final CustomFoldingProvider myProvider;
    private final CustomRegionTreeElement myParent;
    private List<CustomRegionTreeElement> mySubRegions;

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider, @Nullable CustomRegionTreeElement parent) {
        this.myStartElement = startElement;
        this.myProvider = provider;
        this.myParent = parent;
    }

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider) {
        this(startElement, provider, null);
    }

    public Object getValue() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myStartElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myStartElement instanceof Navigatable && ((Navigatable)this.myStartElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return CustomRegionTreeElement.this.myProvider.getPlaceholderText(CustomRegionTreeElement.this.myStartElement.getText());
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.CustomRegion;
            }
        };
    }

    public void addChild(@NotNull StructureViewTreeElement childElement) {
        if (this.mySubRegions != null) {
            for (CustomRegionTreeElement subRegion : this.mySubRegions) {
                if (!subRegion.containsElement(childElement)) continue;
                subRegion.addChild(childElement);
                return;
            }
        }
        this.myChildElements.add(childElement);
    }

    public TreeElement @NotNull [] getChildren() {
        if (this.mySubRegions == null || this.mySubRegions.isEmpty()) {
            return (TreeElement[])this.myChildElements.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        }
        StructureViewTreeElement[] allElements = new StructureViewTreeElement[this.myChildElements.size() + this.mySubRegions.size()];
        int index = 0;
        for (StructureViewTreeElement structureViewTreeElement : this.myChildElements) {
            allElements[index++] = structureViewTreeElement;
        }
        for (StructureViewTreeElement structureViewTreeElement : this.mySubRegions) {
            allElements[index++] = structureViewTreeElement;
        }
        return allElements;
    }

    public boolean containsElement(StructureViewTreeElement element2) {
        TextRange elementRange;
        Object o = element2.getValue();
        return o instanceof PsiElement && (elementRange = ((PsiElement)o).getTextRange()).getStartOffset() >= this.myStartElement.getTextRange().getStartOffset() && elementRange.getEndOffset() <= this.myEndOffset;
    }

    public CustomRegionTreeElement createNestedRegion(@NotNull PsiElement element2) {
        if (this.mySubRegions == null) {
            this.mySubRegions = new ArrayList<CustomRegionTreeElement>();
        }
        CustomRegionTreeElement currSubRegion = new CustomRegionTreeElement(element2, this.myProvider, this);
        this.mySubRegions.add(currSubRegion);
        return currSubRegion;
    }

    public CustomRegionTreeElement endRegion(@NotNull PsiElement element2) {
        this.myEndOffset = element2.getTextRange().getEndOffset();
        return this.myParent;
    }

    public String toString() {
        return "Region '" + this.myProvider.getPlaceholderText(this.myStartElement.getText()) + "'";
    }
}

