/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        return (ScratchRootType)ScratchRootType.findByClass(ScratchRootType.class);
    }

    ScratchRootType() {
        super("scratches", LangBundle.message((String)"root.type.scratches", (Object[])new Object[0]));
    }

    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
        return (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file2);
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        Icon icon2 = (Icon)ObjectUtils.notNull((Object)super.substituteIcon(project, file2), (Object)AllIcons.FileTypes.Text);
        return LayeredIcon.create((Icon)icon2, (Icon)AllIcons.Actions.Scratch);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project, String fileName, Language language, String text) {
        return this.createScratchFile(project, fileName, language, text, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project, String fileName, Language language, String text, ScratchFileService.Option option2) {
        try {
            return (VirtualFile)WriteCommandAction.writeCommandAction((Project)project).withName(UIBundle.message((String)"file.chooser.create.new.scratch.file.command.name", (Object[])new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile((RootType)this, fileName, option2);
                VfsUtil.saveText((VirtualFile)file2, (String)text);
                fileService.getScratchesMapping().setMapping(file2, (Object)language);
                return file2;
            });
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }
}

