/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileCreationHelper {
    public static final LanguageExtension<ScratchFileCreationHelper> EXTENSION = new LanguageExtension("com.intellij.scratch.creationHelper", (Object)new ScratchFileCreationHelper(){});

    public boolean prepareText(@NotNull Project project, @NotNull Context context, @NotNull DataContext dataContext) {
        return false;
    }

    public void beforeCreate(@NotNull Project project, @NotNull Context context) {
    }

    @Nullable
    public static PsiFile parseHeader(@NotNull Project project, @NotNull Language language, @NotNull String text) {
        LanguageFileType fileType = language.getAssociatedFileType();
        String fileSnippet = StringUtil.first((String)text, (int)10240, (boolean)false);
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        return fileFactory.createFileFromText(PathUtil.makeFileName((String)"a", (String)(fileType == null ? "" : fileType.getDefaultExtension())), language, (CharSequence)fileSnippet);
    }

    @NotNull
    public static String reformat(@NotNull Project project, @NotNull Language language, @NotNull String text) {
        return (String)WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiFile psi = ScratchFileCreationHelper.parseHeader(project, language, text);
            if (psi != null) {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psi);
            }
            return psi == null ? text : psi.getText();
        });
    }

    public static class Context {
        @NotNull
        public String text = "";
        public Language language;
        public int caretOffset;
        public String filePrefix;
        public Factory<Integer> fileCounter;
        public String fileExtension;
        public ScratchFileService.Option createOption = ScratchFileService.Option.create_new_always;
        public IdeView ideView;
    }
}

