/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileNode
extends BasePsiNode<PsiFile>
implements NavigatableWithText {
    public PsiFileNode(Project project, @NotNull PsiFile value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @Override
    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        PsiDirectory psiDirectory;
        Project project = this.getProject();
        VirtualFile jarRoot = this.getJarRoot();
        if (project != null && jarRoot != null && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(jarRoot)) != null) {
            return ProjectViewDirectoryHelper.getInstance(project).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        }
        return ContainerUtil.emptyList();
    }

    private boolean isArchive() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType;
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data2) {
        PsiFile value2 = (PsiFile)this.getValue();
        if (value2 != null) {
            data2.setPresentableText(value2.getName());
            data2.setIcon(value2.getIcon(2));
            VirtualFile file2 = this.getVirtualFile();
            if (file2 != null && file2.is(VFileProperty.SYMLINK)) {
                String target2 = file2.getCanonicalPath();
                if (target2 == null) {
                    data2.setAttributesKey(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
                    data2.setTooltip(IdeBundle.message((String)"node.project.view.bad.link", (Object[])new Object[0]));
                } else {
                    data2.setTooltip(FileUtil.toSystemDependentName((String)target2));
                }
            }
        }
    }

    @Override
    public boolean canNavigate() {
        return this.isNavigatableLibraryRoot() || super.canNavigate();
    }

    private boolean isNavigatableLibraryRoot() {
        VirtualFile jarRoot = this.getJarRoot();
        Project project = this.getProject();
        if (jarRoot != null && project != null && ProjectRootsUtil.isLibraryRoot(jarRoot, project)) {
            OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)jarRoot, (Project)project);
            return orderEntry != null && ProjectSettingsService.getInstance(project).canOpenLibraryOrSdkSettings(orderEntry);
        }
        return false;
    }

    @Nullable
    private VirtualFile getJarRoot() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || !file2.isValid() || !(file2.getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        return JarFileSystem.getInstance().getJarRootForLocalFile(file2);
    }

    @Override
    public void navigate(boolean requestFocus) {
        OrderEntry orderEntry;
        VirtualFile jarRoot = this.getJarRoot();
        Project project = this.getProject();
        if (requestFocus && jarRoot != null && project != null && ProjectRootsUtil.isLibraryRoot(jarRoot, project) && (orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)jarRoot, (Project)project)) != null) {
            ProjectSettingsService.getInstance(project).openLibraryOrSdkSettings(orderEntry);
            return;
        }
        super.navigate(requestFocus);
    }

    public String getNavigateActionText(boolean focusEditor) {
        return this.isNavigatableLibraryRoot() ? ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]) : null;
    }

    public int getWeight() {
        return 20;
    }

    public String getTitle() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null ? FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl()) : super.getTitle();
    }

    @Override
    protected boolean isMarkReadOnly() {
        return true;
    }

    public Comparable<ExtensionSortKey> getTypeSortKey() {
        String extension = PsiFileNode.extension((PsiFile)this.getValue());
        return extension == null ? null : new ExtensionSortKey(extension);
    }

    @Nullable
    public static String extension(@Nullable PsiFile file2) {
        VirtualFile vFile;
        if (file2 != null && (vFile = file2.getVirtualFile()) != null) {
            return vFile.getFileType().getDefaultExtension();
        }
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        PsiFile file2 = (PsiFile)this.getValue();
        return file2 != null && file2.getFileType() == StdFileTypes.JAVA;
    }

    public boolean canRepresent(Object element2) {
        if (super.canRepresent(element2)) {
            return true;
        }
        PsiFile value2 = (PsiFile)this.getValue();
        return value2 != null && element2 != null && element2.equals(value2.getVirtualFile());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        return super.contains(file2) || this.isArchive() && Comparing.equal((Object)VfsUtil.getLocalFile((VirtualFile)file2), (Object)this.getVirtualFile());
    }

    public static class ExtensionSortKey
    implements Comparable<ExtensionSortKey> {
        private final String myExtension;

        public ExtensionSortKey(@NotNull String extension) {
            this.myExtension = extension;
        }

        @Override
        public int compareTo(ExtensionSortKey o) {
            return o == null ? 0 : this.myExtension.compareTo(o.myExtension);
        }
    }
}

