/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.actions.OpenModuleSettingsAction;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigureUnloadedModulesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/projectView/actions/LoadUnloadModulesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedUnloadedModuleName", "", "isEnabled", "", "update", "intellij.platform.lang.impl"})
public final class LoadUnloadModulesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        if (moduleManager.getModules().length <= 1 && moduleManager.getUnloadedModuleDescriptions().isEmpty()) {
            return false;
        }
        VirtualFile file2 = (VirtualFile)e.getData(LangDataKeys.VIRTUAL_FILE);
        return !ActionPlaces.isPopupPlace((String)e.getPlace()) || OpenModuleSettingsAction.isModuleInContext(e) || file2 != null && ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, project2) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        Object object2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = object = this.getSelectedUnloadedModuleName(e);
        }
        if (object2 == null) {
            Module module = (Module)e.getData(LangDataKeys.MODULE);
            object = module != null ? module.getName() : null;
        }
        Object selectedModuleName = object;
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        new ConfigureUnloadedModulesDialog(project, (String)selectedModuleName).show();
    }

    private final String getSelectedUnloadedModuleName(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(LangDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        return ProjectRootsUtil.findUnloadedModuleByFile(file2, project2);
    }

    public LoadUnloadModulesAction() {
        super("Load/Unload Modules...");
    }
}

