/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.3")
public abstract class BaseProjectTreeBuilder
extends AbstractTreeBuilder {
    protected final Project myProject;

    public BaseProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor<?>> comparator2) {
        this.init(tree, treeModel, treeStructure, comparator2, true);
        this.getUi().setClearOnHideDelay((long)Registry.intValue((String)"ide.tree.clearOnHideTime"));
        this.myProject = project;
    }

    @NotNull
    public Promise<Object> revalidateElement(@NotNull Object element2) {
        if (!(element2 instanceof AbstractTreeNode)) {
            return Promises.rejectedPromise();
        }
        AsyncPromise result2 = new AsyncPromise();
        AbstractTreeNode node = (AbstractTreeNode)element2;
        Object value2 = node.getValue();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ObjectUtils.tryCast((Object)value2, PsiElement.class)));
        this.batch(indicator -> {
            Ref target2 = new Ref();
            Promise<Object> callback2 = this._select(element2, virtualFile, true, Conditions.alwaysTrue());
            callback2.onSuccess(it -> result2.setResult(target2.get())).onError(e -> result2.setError(e));
        });
        return result2;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor instanceof AbstractTreeNode && ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null || nodeDescriptor instanceof AbstractTreeNode && ((AbstractTreeNode)nodeDescriptor).isAlwaysExpand();
    }

    protected final void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
        if (userObject == null) {
            return;
        }
        Object element2 = userObject.getElement();
        VirtualFile virtualFile = BaseProjectTreeBuilder.getFileToRefresh(element2);
        super.expandNodeChildren(node);
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
    }

    private static VirtualFile getFileToRefresh(Object element2) {
        Object object = element2;
        if (element2 instanceof AbstractTreeNode) {
            object = ((AbstractTreeNode)element2).getValue();
        }
        return object instanceof PsiDirectory ? ((PsiDirectory)object).getVirtualFile() : (object instanceof PsiFile ? ((PsiFile)object).getVirtualFile() : null);
    }

    @NotNull
    private static List<AbstractTreeNode<?>> collectChildren(@NotNull DefaultMutableTreeNode node) {
        int childCount = node.getChildCount();
        ArrayList result2 = new ArrayList(childCount);
        for (int i2 = 0; i2 < childCount; ++i2) {
            AbstractTreeNode treeNode;
            TreeNode childAt = node.getChildAt(i2);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)childAt;
            if (defaultMutableTreeNode.getUserObject() instanceof AbstractTreeNode) {
                treeNode = (AbstractTreeNode)defaultMutableTreeNode.getUserObject();
                result2.add(treeNode);
                continue;
            }
            if (!(defaultMutableTreeNode.getUserObject() instanceof FavoriteTreeNodeDescriptor)) continue;
            treeNode = ((FavoriteTreeNodeDescriptor)((Object)defaultMutableTreeNode.getUserObject())).getElement();
            result2.add(treeNode);
        }
        return result2;
    }

    @Deprecated
    @NotNull
    public ActionCallback select(Object element2, VirtualFile file2, boolean requestFocus) {
        return Promises.toActionCallback(this._select(element2, file2, requestFocus, Conditions.alwaysTrue()));
    }

    @NotNull
    public Promise<Object> selectAsync(Object element2, VirtualFile file2, boolean requestFocus) {
        return this._select(element2, file2, requestFocus, Conditions.alwaysTrue());
    }

    public ActionCallback selectInWidth(Object element2, boolean requestFocus, Condition<AbstractTreeNode<?>> nonStopCondition) {
        return Promises.toActionCallback(this._select(element2, null, requestFocus, nonStopCondition));
    }

    @NotNull
    private Promise<Object> _select(Object element2, VirtualFile file2, boolean requestFocus, Condition<? super AbstractTreeNode<?>> nonStopCondition) {
        AbstractTreeUpdater updater2 = this.getUpdater();
        if (updater2 == null) {
            return Promises.rejectedPromise();
        }
        AsyncPromise result2 = new AsyncPromise();
        UiActivityMonitor.getInstance().addActivity(this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"), updater2.getModalityState());
        this.batch(indicator -> {
            this._select(element2, file2, requestFocus, nonStopCondition, (AsyncPromise<Object>)result2, indicator, null, null, false);
            UiActivityMonitor.getInstance().removeActivity(this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"));
        });
        return result2;
    }

    private void _select(Object element2, VirtualFile file2, boolean requestFocus, Condition<? super AbstractTreeNode<?>> nonStopCondition, AsyncPromise<Object> result2, @NotNull ProgressIndicator indicator, @Nullable Ref<Object> virtualSelectTarget, FocusRequestor focusRequestor, boolean isSecondAttempt) {
        AbstractTreeNode alreadySelected = this.alreadySelectedNode(element2);
        Runnable onDone = () -> {
            JTree tree = this.getTree();
            if (tree != null && requestFocus && virtualSelectTarget == null && this.getUi().isReady()) {
                tree.requestFocus();
            }
            result2.setResult(null);
        };
        Condition condition = abstractTreeNode -> result2.getState() == Promise.State.PENDING && nonStopCondition.value(abstractTreeNode);
        if (alreadySelected == null) {
            this.expandPathTo(file2, (AbstractTreeNode)this.getTreeStructure().getRootElement(), element2, condition, indicator, virtualSelectTarget).onSuccess(node -> {
                if (virtualSelectTarget == null) {
                    this.select(node, onDone);
                } else {
                    onDone.run();
                }
            }).onError(error -> {
                if (isSecondAttempt) {
                    result2.cancel();
                } else {
                    this._select(file2, file2, requestFocus, nonStopCondition, result2, indicator, virtualSelectTarget, focusRequestor, true);
                }
            });
        } else if (virtualSelectTarget == null) {
            this.scrollTo(alreadySelected, onDone);
        } else {
            onDone.run();
        }
    }

    private AbstractTreeNode alreadySelectedNode(Object element2) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        for (TreePath selectionPath : selectionPaths) {
            Object userObject;
            Object selected2 = selectionPath.getLastPathComponent();
            if (!(selected2 instanceof DefaultMutableTreeNode) || !BaseProjectTreeBuilder.elementIsEqualTo(selected2, element2) || !((userObject = ((DefaultMutableTreeNode)selected2).getUserObject()) instanceof AbstractTreeNode)) continue;
            return (AbstractTreeNode)userObject;
        }
        return null;
    }

    private static boolean elementIsEqualTo(Object node, Object element2) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)userObject;
            return projectViewNode.canRepresent(element2);
        }
        return false;
    }

    protected boolean canExpandPathTo(@NotNull AbstractTreeNode<?> root, Object element2) {
        return true;
    }

    @NotNull
    private Promise<AbstractTreeNode<?>> expandPathTo(VirtualFile file2, @NotNull AbstractTreeNode root, Object element2, @NotNull Condition<AbstractTreeNode<?>> nonStopCondition, @NotNull ProgressIndicator indicator, @Nullable Ref<Object> target2) {
        AsyncPromise async = new AsyncPromise();
        if (root.canRepresent(element2)) {
            if (target2 == null) {
                this.expand(root, () -> async.setResult((Object)root));
            } else {
                target2.set((Object)root);
                async.setResult((Object)root);
            }
            return async;
        }
        if (!this.canExpandPathTo(root, element2)) {
            async.setError("cannot expand");
            return async;
        }
        if (root instanceof ProjectViewNode && file2 != null && !((ProjectViewNode)root).contains(file2)) {
            async.setError("not applicable");
            return async;
        }
        if (target2 == null) {
            this.expand(root, () -> {
                indicator.checkCanceled();
                DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
                if (rootNode != null) {
                    List<AbstractTreeNode<?>> kids = BaseProjectTreeBuilder.collectChildren(rootNode);
                    this.expandChild(kids, 0, nonStopCondition, file2, element2, async, indicator, target2);
                } else {
                    async.cancel();
                }
            });
        } else if (indicator.isCanceled()) {
            async.cancel();
        } else {
            DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
            ArrayList<Object> kids = new ArrayList<Object>();
            if (rootNode != null && this.getTree().isExpanded(new TreePath(rootNode.getPath()))) {
                kids.addAll(BaseProjectTreeBuilder.collectChildren(rootNode));
            } else {
                Object[] childElements;
                for (Object each : childElements = this.getTreeStructure().getChildElements((Object)root)) {
                    kids.add((AbstractTreeNode)each);
                }
            }
            this.yieldToEDT(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.expandChild(kids, 0, nonStopCondition, file2, element2, async, indicator, target2);
            });
        }
        return async;
    }

    private void expandChild(@NotNull List<? extends AbstractTreeNode<?>> kids, int i2, @NotNull Condition<AbstractTreeNode<?>> nonStopCondition, VirtualFile file2, Object element2, @NotNull AsyncPromise<? super AbstractTreeNode<?>> async, @NotNull ProgressIndicator indicator, Ref<Object> virtualSelectTarget) {
        while (i2 < kids.size()) {
            AbstractTreeNode<?> eachKid = kids.get(i2);
            boolean[] nodeWasCollapsed = new boolean[]{true};
            DefaultMutableTreeNode nodeForElement = this.getNodeForElement(eachKid);
            if (nodeForElement != null) {
                nodeWasCollapsed[0] = this.getTree().isCollapsed(new TreePath(nodeForElement.getPath()));
            }
            if (!nonStopCondition.value(eachKid)) break;
            Promise<AbstractTreeNode<?>> result2 = this.expandPathTo(file2, eachKid, element2, nonStopCondition, indicator, virtualSelectTarget);
            result2.onSuccess(abstractTreeNode -> {
                indicator.checkCanceled();
                async.setResult(abstractTreeNode);
            });
            if (result2.getState() == Promise.State.PENDING) {
                int next = i2 + 1;
                result2.onError(error -> {
                    indicator.checkCanceled();
                    if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                        this.collapseChildren(eachKid, null);
                    }
                    this.expandChild(kids, next, nonStopCondition, file2, element2, async, indicator, virtualSelectTarget);
                });
                return;
            }
            if (result2.getState() == Promise.State.REJECTED) {
                indicator.checkCanceled();
                if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                    this.collapseChildren(eachKid, null);
                }
                ++i2;
                continue;
            }
            return;
        }
        async.cancel();
    }

    protected boolean validateNode(@NotNull Object child2) {
        if (child2 == null) {
            return false;
        }
        if (child2 instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)child2;
            return projectViewNode.validate();
        }
        return true;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }
}

