/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class LazyPluginLogoIcon
implements PluginLogoIconProvider {
    private PluginLogoIconProvider myLogoIcon;
    private final Map<String, LazyIcon> myIcons = new HashMap<String, LazyIcon>();

    LazyPluginLogoIcon(@NotNull PluginLogoIconProvider logoIcon) {
        this.myLogoIcon = logoIcon;
    }

    @Override
    @NotNull
    public Icon getIcon(boolean big, boolean jb, boolean error, boolean disabled) {
        String key = String.valueOf(big) + jb + error + disabled;
        LazyIcon icon2 = this.myIcons.get(key);
        if (icon2 == null) {
            icon2 = new LazyIcon(new boolean[]{big, jb, error, disabled});
            this.myIcons.put(key, icon2);
            icon2.setIcon(this.myLogoIcon, false);
        }
        return icon2;
    }

    void setLogoIcon(@NotNull PluginLogoIconProvider logoIcon) {
        this.myLogoIcon = logoIcon;
        for (LazyIcon icon2 : this.myIcons.values()) {
            icon2.setIcon(logoIcon, true);
        }
    }

    private static class LazyIcon
    implements Icon {
        private final boolean[] myState;
        private Icon myIcon;
        private Set<Component> myComponents = ContainerUtil.createWeakSet();

        private LazyIcon(boolean @NotNull [] state) {
            this.myState = state;
        }

        private void setIcon(@NotNull PluginLogoIconProvider logoIcon, boolean repaint) {
            if (repaint) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.setIcon(logoIcon);
                    Set<Component> components = this.myComponents;
                    this.myComponents = null;
                    for (Component component2 : components) {
                        if (!component2.isShowing()) continue;
                        component2.repaint();
                    }
                }, ModalityState.any());
            } else {
                this.setIcon(logoIcon);
            }
        }

        private void setIcon(@NotNull PluginLogoIconProvider logoIcon) {
            this.myIcon = logoIcon.getIcon(this.myState[0], this.myState[1], this.myState[2], this.myState[3]);
        }

        @Override
        public void paintIcon(Component component2, Graphics g, int x, int y) {
            this.myIcon.paintIcon(component2, g, x, y);
            if (this.myComponents != null) {
                this.myComponents.add(component2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

