/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BasePathResolver;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PluginXmlPathResolver
extends BasePathResolver {
    private static final Logger LOG = Logger.getInstance(PluginXmlPathResolver.class);
    private final List<Path> pluginJarFiles;
    private final DescriptorLoadingContext context;

    PluginXmlPathResolver(@NotNull List<Path> pluginJarFiles, @NotNull DescriptorLoadingContext context) {
        this.pluginJarFiles = pluginJarFiles;
        this.context = context;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull List<Path> bases, @NotNull String relativePath, @Nullable String base, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        try {
            return super.resolvePath(bases, relativePath, base, jdomFactory);
        }
        catch (NoSuchFileException mainError) {
            Element element2;
            if (relativePath.charAt(0) != '/' && !bases.isEmpty()) {
                relativePath = bases.get(bases.size() - 1) + "/" + relativePath;
            }
            if ((element2 = this.findInJarFiles(relativePath, jdomFactory)) != null) {
                return element2;
            }
            throw mainError;
        }
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull Path basePath, @NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        try {
            return super.resolvePath(basePath, relativePath, jdomFactory);
        }
        catch (NoSuchFileException mainError) {
            Element element2;
            if (relativePath.charAt(0) != '/') {
                relativePath = basePath.toString() + "/" + relativePath;
            }
            if ((element2 = this.findInJarFiles(relativePath, jdomFactory)) != null) {
                return element2;
            }
            throw mainError;
        }
    }

    @Nullable
    private Element findInJarFiles(@NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws JDOMException, IOException {
        InputStream stream;
        for (Path jarFile : this.pluginJarFiles) {
            FileSystem fileSystem;
            try {
                fileSystem = this.context.open(jarFile);
            }
            catch (IOException e) {
                LOG.error("Corrupted jar file: " + jarFile, (Throwable)e);
                continue;
            }
            Path path = fileSystem.getPath(relativePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return JDOMUtil.load((Path)path, (SafeJdomFactory)jdomFactory);
        }
        if (relativePath.startsWith("/META-INF/") && (stream = PluginXmlPathResolver.class.getResourceAsStream(relativePath)) != null) {
            return JDOMUtil.load((InputStream)stream);
        }
        return null;
    }
}

