/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurableTreeRenderer
extends AncestorListenerAdapter
implements ConfigurableTreeRenderer,
Consumer<Integer> {
    private final CountComponent myCountLabel = new CountComponent();
    private final JLabel myExtraLabel = new JLabel();
    private final JPanel myPanel = new NonOpaquePanel();
    private PluginUpdatesService myService;
    private SimpleTree myTree;
    private String myCountValue;

    public PluginManagerConfigurableTreeRenderer() {
        this.myPanel.setLayout(new BorderLayout(PluginManagerConfigurableTreeRenderer.getHGap(), 0));
        this.myPanel.add((Component)this.myCountLabel, "West");
        this.myPanel.add((Component)this.myExtraLabel, "East");
    }

    @Nullable
    private static Icon getExtraIcon() {
        return DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions() ? AllIcons.Plugins.Hieroglyph : null;
    }

    @Nullable
    public Pair<Component, ConfigurableTreeRenderer.Layout> getDecorator(@NotNull SimpleTree tree, @Nullable UnnamedConfigurable configurable2, boolean selected2) {
        Icon icon2;
        if (this.myTree == null) {
            this.myService = PluginUpdatesService.connectTreeRenderer(this);
            tree.addAncestorListener((AncestorListener)((Object)this));
            this.myTree = tree;
        }
        if ((icon2 = PluginManagerConfigurableTreeRenderer.getExtraIcon()) == null && this.myCountValue == null) {
            return null;
        }
        this.myCountLabel.setText(StringUtil.defaultIfEmpty((String)this.myCountValue, (String)"0"));
        this.myCountLabel.setSelected(selected2);
        this.myExtraLabel.setIcon(icon2);
        this.myExtraLabel.setBackground(this.myCountLabel.getBackground());
        JComponent component2 = icon2 != null && this.myCountValue != null ? this.myPanel : (icon2 == null ? this.myCountLabel : this.myExtraLabel);
        return Pair.create((Object)component2, (renderer, bounds2, text, right, textBaseline) -> {
            Dimension size = renderer.getPreferredSize();
            int x = right.x - JBUIScale.scale((int)2) + (right.width - size.width) / 2;
            if (icon2 != null && this.myCountValue != null) {
                x -= PluginManagerConfigurableTreeRenderer.getHGap() + this.myExtraLabel.getPreferredSize().width / 2;
            }
            int y = bounds2.y + textBaseline - this.myCountLabel.getBaseline(size.width, size.height);
            renderer.setBounds(x, y, size.width, size.height);
            renderer.doLayout();
        });
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.myService.dispose();
    }

    @Override
    public void accept(Integer countValue) {
        String oldCountValue = this.myCountValue;
        String string = this.myCountValue = countValue == null || countValue <= 0 ? null : countValue.toString();
        if (this.myTree != null && !StringUtil.equals((CharSequence)oldCountValue, (CharSequence)this.myCountValue)) {
            this.myTree.repaint();
        }
    }

    private static int getHGap() {
        return JBUIScale.scale((int)3);
    }
}

