/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.extensions.PluginId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PluginError {
    final IdeaPluginDescriptorImpl plugin;
    private final String message;
    private final String incompatibleReason;
    private boolean myNotifyUser;
    private PluginId myDisabledDependency;

    public PluginError(@Nullable IdeaPluginDescriptorImpl plugin, @NotNull String message, @Nullable String incompatibleReason) {
        this(plugin, message, incompatibleReason, true);
    }

    public PluginError(@Nullable IdeaPluginDescriptorImpl plugin, @NotNull String message, @Nullable String incompatibleReason, boolean notifyUser) {
        this.plugin = plugin;
        this.message = message;
        this.incompatibleReason = incompatibleReason;
        this.myNotifyUser = notifyUser;
    }

    void setDisabledDependency(PluginId disabledDependency) {
        this.myDisabledDependency = disabledDependency;
    }

    @NotNull
    String toUserError() {
        if (this.plugin == null) {
            return this.message;
        }
        if (this.incompatibleReason != null) {
            return "Plugin \"" + this.plugin.getName() + "\" is incompatible (" + this.incompatibleReason + ")";
        }
        return "Plugin \"" + this.plugin.getName() + "\" " + this.message;
    }

    String getMessage() {
        return this.message;
    }

    String getIncompatibleReason() {
        return this.incompatibleReason;
    }

    PluginId getDisabledDependency() {
        return this.myDisabledDependency;
    }

    boolean isNotifyUser() {
        return this.myNotifyUser;
    }

    @NotNull
    public String toString() {
        return this.plugin == null ? this.message : this.plugin.formatErrorMessage(this.message);
    }
}

