/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ui.components.labels.LinkLabel;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkPanel {
    private final JLabel myTextLabel = new JLabel();
    private final JLabel myLinkLabel;
    private Runnable myRunnable;

    public LinkPanel(@NotNull JPanel parent, boolean icon2, @Nullable Object labelConstraints, @Nullable Object linkConstraints) {
        this.myLinkLabel = this.createLink(icon2);
        this.myTextLabel.setForeground(ListPluginComponent.GRAY_COLOR);
        parent.add((Component)this.myTextLabel, labelConstraints);
        parent.add((Component)this.myLinkLabel, linkConstraints);
    }

    @NotNull
    private JLabel createLink(boolean icon2) {
        LinkLabel linkLabel = new LinkLabel(null, icon2 ? AllIcons.Ide.External_link_arrow : null, (__, ___) -> this.myRunnable.run());
        linkLabel.setIconTextGap(0);
        linkLabel.setHorizontalTextPosition(2);
        return linkLabel;
    }

    public void show(@NotNull @Nls String text, @Nullable Runnable linkCallback) {
        this.myRunnable = linkCallback;
        if (linkCallback == null) {
            this.myTextLabel.setText(text);
            this.myTextLabel.setVisible(true);
            this.myLinkLabel.setVisible(false);
        } else {
            this.myTextLabel.setVisible(false);
            this.myLinkLabel.setText(text);
            this.myLinkLabel.setVisible(true);
        }
    }

    public void hide() {
        this.myRunnable = null;
        this.myTextLabel.setVisible(false);
        this.myLinkLabel.setVisible(false);
    }
}

