/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class BundledPluginsLister
implements ApplicationStarter {
    BundledPluginsLister() {
    }

    public String getCommandName() {
        return "listBundledPlugins";
    }

    public int getRequiredModality() {
        return 3;
    }

    public void main(@NotNull List<String> args) {
        try {
            Writer out;
            if (args.size() == 2) {
                Path outFile = Paths.get(args.get(1), new String[0]);
                Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
                out = Files.newBufferedWriter(outFile, new OpenOption[0]);
            } else {
                out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
            }
            try (JsonWriter writer = new JsonWriter(out);){
                List<? extends IdeaPluginDescriptor> plugins = PluginManagerCore.getLoadedPlugins();
                ArrayList<String> modules2 = new ArrayList<String>();
                ArrayList<String> pluginIds = new ArrayList<String>(plugins.size());
                for (IdeaPluginDescriptor ideaPluginDescriptor : plugins) {
                    pluginIds.add(ideaPluginDescriptor.getPluginId().getIdString());
                    for (PluginId pluginId : ((IdeaPluginDescriptorImpl)ideaPluginDescriptor).getModules()) {
                        modules2.add(pluginId.getIdString());
                    }
                }
                pluginIds.sort(null);
                modules2.sort(null);
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (FileType type : fileTypeManager.getRegisteredFileTypes()) {
                    if (type instanceof PlainTextLikeFileType) continue;
                    for (FileNameMatcher matcher : fileTypeManager.getAssociations(type)) {
                        arrayList.add(matcher.getPresentableString());
                    }
                }
                writer.beginObject();
                BundledPluginsLister.writeList(writer, "modules", modules2);
                BundledPluginsLister.writeList(writer, "plugins", pluginIds);
                BundledPluginsLister.writeList(writer, "extensions", arrayList);
                writer.endObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void writeList(@NotNull JsonWriter writer, String name, @NotNull List<String> elements2) throws IOException {
        writer.name(name).beginArray();
        for (String module : elements2) {
            writer.value(module);
        }
        writer.endArray();
    }
}

