/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ContentRootMacro
extends Macro {
    @Override
    @NotNull
    public String getName() {
        return "ContentRoot";
    }

    @Override
    @NotNull
    public String getDescription() {
        return IdeBundle.message((String)"macro.content.root", (Object[])new Object[0]);
    }

    @Override
    public String expand(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (project == null || file2 == null) {
            return null;
        }
        VirtualFile contentRoot = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file2);
        return contentRoot == null ? null : FileUtil.toSystemDependentName((String)contentRoot.getPath());
    }
}

