/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditAutosaveWidget
implements StatusBarWidget,
StatusBarWidget.TextPresentation,
LightEditorListener {
    private final LightEditorManager myLightEditorManager;
    private StatusBar myStatusBar;

    public LightEditAutosaveWidget(@NotNull LightEditorManager editorManager) {
        this.myLightEditorManager = editorManager;
    }

    @NotNull
    public String ID() {
        return "light.edit.autosave";
    }

    public void install(@NotNull StatusBar statusBar) {
        this.myStatusBar = statusBar;
        this.myLightEditorManager.addListener((LightEditorListener)this);
        this.myStatusBar.updateWidget(this.ID());
    }

    public void dispose() {
    }

    public @NlsContexts.Tooltip @Nullable String getTooltipText() {
        return IdeBundle.message((String)"tooltip.autosave.mode", (Object[])new Object[0]);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return event -> {
            Component widgetComp = event.getComponent();
            if (widgetComp != null) {
                MyModePanel modePanel = new MyModePanel();
                modePanel.setAutosaveSelected(LightEditService.getInstance().isAutosaveMode());
                ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)modePanel, null);
                JBPopup popup2 = builder2.createPopup();
                popup2.show(new RelativePoint(widgetComp, new Point(0, -modePanel.getPreferredSize().height)));
            }
        };
    }

    @NotNull
    public String getText() {
        return ApplicationBundle.message((String)"light.edit.autosave.widget.text", (Object[])new Object[]{LightEditService.getInstance().isAutosaveMode() ? ApplicationBundle.message((String)"light.edit.autosave.widget.on", (Object[])new Object[0]) : ApplicationBundle.message((String)"light.edit.autosave.widget.off", (Object[])new Object[0])});
    }

    public float getAlignment() {
        return 0.0f;
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void autosaveModeChanged(boolean isAutosave) {
        LightEditFeatureUsagesUtil.logAutosaveModeChanged(isAutosave);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static class MyModePanel
    extends JPanel {
        private final JCheckBox myModeCb;

        MyModePanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(JBUI.Borders.empty((int)10));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            this.myModeCb = new JCheckBox();
            this.add((Component)this.myModeCb, c);
            c.gridx = 1;
            c.gridy = 0;
            c.insets = JBUI.insetsLeft((int)10);
            this.add((Component)new JLabel(ApplicationBundle.message((String)"light.edit.autosave.widget.popup.title", (Object[])new Object[0])), c);
            c.fill = 0;
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = JBUI.insets((int)5, (int)10, (int)0, (int)0);
            JLabel label2 = new JLabel(MyModePanel.getPopupText());
            label2.setForeground((Color)JBColor.GRAY);
            this.add((Component)label2, c);
            this.myModeCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LightEditService.getInstance().setAutosaveMode(myModeCb.isSelected());
                }
            });
        }

        private static String getPopupText() {
            StringBuilder builder2 = new StringBuilder();
            GeneralSettings generalSettings = GeneralSettings.getInstance();
            if (generalSettings.isAutoSaveIfInactive()) {
                builder2.append(ApplicationBundle.message((String)"light.edit.autosave.widget.popup.text.time", (Object[])new Object[]{generalSettings.getInactiveTimeout()}));
            }
            if (generalSettings.isSaveOnFrameDeactivation()) {
                if (builder2.length() > 0) {
                    builder2.append(",<br>");
                }
                String message = ApplicationBundle.message((String)"light.edit.autosave.widget.popup.text.deactivation", (Object[])new Object[0]);
                if (builder2.length() > 0) {
                    message = message.replaceAll("<br>", " ");
                }
                builder2.append(message);
            }
            if (builder2.length() == 0) {
                builder2.append(ApplicationBundle.message((String)"light.edit.autosave.widget.popup.text.on.close", (Object[])new Object[0]));
            }
            return ApplicationBundle.message((String)"light.edit.autosave.widget.popup.text", (Object[])new Object[]{builder2.toString()});
        }

        public void setAutosaveSelected(boolean isSelected) {
            this.myModeCb.setSelected(isSelected);
        }
    }
}

