/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditUtil {
    private static final String ENABLED_FILE_OPEN_KEY = "light.edit.file.open.enabled";
    private static final String OPEN_FILE_IN_PROJECT_HREF = "open_file_in_project";
    private static boolean ourForceOpenInExistingProjectFlag;

    private LightEditUtil() {
    }

    public static boolean openFile(@NotNull Path path) {
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (virtualFile != null && LightEdit.openFile((VirtualFile)virtualFile)) {
            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            return true;
        }
        return false;
    }

    public static boolean isOpenInExistingProject() {
        return ourForceOpenInExistingProjectFlag && ProjectManager.getInstance().getOpenProjects().length > 0;
    }

    @NotNull
    public static Project getProject() {
        return LightEditService.getInstance().getOrCreateProject();
    }

    @Nullable
    public static Project getProjectIfCreated() {
        return LightEditService.getInstance().getProject();
    }

    static boolean confirmClose(@NotNull String message, @NotNull String title, @NotNull LightEditSaveConfirmationHandler handler2) {
        String[] options2 = new String[]{LightEditUtil.getCloseSave(), LightEditUtil.getCloseDiscard(), LightEditUtil.getCloseCancel()};
        int result2 = Messages.showDialog((Project)LightEditUtil.getProject(), (String)message, (String)title, (String[])options2, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 >= 0) {
            if (LightEditUtil.getCloseCancel().equals(options2[result2])) {
                return false;
            }
            if (LightEditUtil.getCloseSave().equals(options2[result2])) {
                handler2.onSave();
            } else if (LightEditUtil.getCloseDiscard().equals(options2[result2])) {
                handler2.onDiscard();
            }
            return true;
        }
        return false;
    }

    @Nullable
    static VirtualFile chooseTargetFile(@NotNull Component parent, @NotNull LightEditorInfo editorInfo) {
        FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(IdeBundle.message((String)"dialog.title.save.as", (Object[])new Object[0]), IdeBundle.message((String)"label.choose.target.file", (Object[])new Object[0]), LightEditUtil.getKnownExtensions()), parent);
        VirtualFileWrapper fileWrapper = saver.save(VfsUtil.getUserHomeDir(), editorInfo.getFile().getPresentableName());
        if (fileWrapper != null) {
            return fileWrapper.getVirtualFile(true);
        }
        return null;
    }

    private static String[] getKnownExtensions() {
        return ArrayUtil.toStringArray((Collection)Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).map(fileType -> fileType.getDefaultExtension()).sorted().distinct().collect(Collectors.toList()));
    }

    private static String getCloseSave() {
        return ApplicationBundle.message((String)"light.edit.close.save", (Object[])new Object[0]);
    }

    private static String getCloseDiscard() {
        return ApplicationBundle.message((String)"light.edit.close.discard", (Object[])new Object[0]);
    }

    private static String getCloseCancel() {
        return ApplicationBundle.message((String)"light.edit.close.cancel", (Object[])new Object[0]);
    }

    public static void markUnknownFileTypeAsPlainTextIfNeeded(@Nullable Project project, @NotNull VirtualFile file2) {
        if (project != null && !project.isDefault() && !LightEdit.owns((Project)project)) {
            return;
        }
        if (LightEditUtil.isLightEditEnabled()) {
            LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        }
    }

    static boolean isLightEditEnabled() {
        return Registry.is((String)ENABLED_FILE_OPEN_KEY) && !PlatformUtils.isDataGrip();
    }

    @ApiStatus.Internal
    @NotNull
    public static EmptyCompletionNotifier createEmptyCompletionNotifier() {
        return new EmptyCompletionNotifier(){

            @Override
            public void showIncompleteHint(@NotNull Editor editor, @NotNull String text, boolean isDumbMode) {
                HintManager.getInstance().showInformationHint(editor, StringUtil.escapeXmlEntities((String)text) + CodeInsightBundle.message((String)"completion.incomplete.light.edit.suffix", (Object[])new Object[]{LightEditUtil.OPEN_FILE_IN_PROJECT_HREF}), e -> {
                    VirtualFile file2;
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && LightEditUtil.OPEN_FILE_IN_PROJECT_HREF.equals(e.getDescription()) && (file2 = LightEditService.getInstance().getSelectedFile()) != null) {
                        LightEditOpenInProjectIntention.performOn(file2);
                    }
                });
            }
        };
    }

    public static void setForceOpenInExistingProject(boolean openInExistingProject) {
        ourForceOpenInExistingProjectFlag = openInExistingProject;
    }
}

