/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditSaveStatusIcon;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditTabAttributesProvider;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditTabs
extends JBEditorTabs
implements LightEditorListener,
CloseAction.CloseTarget {
    private final LightEditorManagerImpl myEditorManager;
    private final ExecutorService myTabUpdateExecutor;

    LightEditTabs(@NotNull Disposable parentDisposable, @NotNull LightEditorManagerImpl editorManager) {
        super(LightEditUtil.getProject(), null, parentDisposable);
        this.myEditorManager = editorManager;
        this.myTabUpdateExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Light Edit Tabs Update", (int)1);
        Disposer.register((Disposable)parentDisposable, () -> this.myTabUpdateExecutor.shutdown());
        this.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                ObjectUtils.consumeIfNotNull((Object)oldSelection, tabInfo -> tabInfo.setTabColor(null));
                LightEditTabs.this.asyncUpdateTab(newSelection);
                LightEditTabs.this.onSelectionChange(newSelection);
            }
        });
        this.myEditorManager.addListener(this, parentDisposable);
    }

    void addEditorTab(@NotNull LightEditorInfo editorInfo) {
        this.addEditorTab(editorInfo, -1);
    }

    private void addEditorTab(@NotNull LightEditorInfo editorInfo, int index) {
        TabInfo tabInfo = new TabInfo((JComponent)new EditorContainer(editorInfo.getFileEditor())).setText(editorInfo.getFile().getPresentableName()).setIcon(LightEditTabs.getFileTypeIcon(editorInfo));
        tabInfo.setObject((Object)editorInfo);
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTabAction(editorInfo));
        tabInfo.setTabLabelActions((ActionGroup)tabActions, "EditorTab");
        this.addTabSilently(tabInfo, index);
        this.select(tabInfo, true);
        this.asyncUpdateTab(tabInfo);
        this.myEditorManager.fireEditorSelected(editorInfo);
    }

    @Override
    public void close() {
        ObjectUtils.consumeIfNotNull((Object)this.getSelectedInfo(), tabInfo -> this.closeTab((TabInfo)tabInfo));
    }

    private static Icon getFileTypeIcon(@NotNull LightEditorInfo editorInfo) {
        return editorInfo.getFile().getFileType().getIcon();
    }

    private void onSelectionChange(@Nullable TabInfo tabInfo) {
        Object data2;
        LightEditorInfo selectedEditorInfo = null;
        if (tabInfo != null && (data2 = tabInfo.getObject()) instanceof LightEditorInfo) {
            selectedEditorInfo = (LightEditorInfo)data2;
        }
        this.myEditorManager.fireEditorSelected(selectedEditorInfo);
    }

    void selectTab(@NotNull LightEditorInfo info) {
        this.getTabs().stream().filter(tabInfo -> tabInfo.getObject().equals(info)).findFirst().ifPresent(tabInfo -> this.select((TabInfo)tabInfo, true));
    }

    private void closeTab(@NotNull TabInfo tabInfo) {
        LightEditorInfo editorInfo;
        Object data2 = tabInfo.getObject();
        if (data2 instanceof LightEditorInfo && (!(editorInfo = (LightEditorInfo)data2).isUnsaved() || this.autosaveDocument(editorInfo) || LightEditUtil.confirmClose(ApplicationBundle.message((String)"light.edit.close.message", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.close.title", (Object[])new Object[0]), new LightEditSaveConfirmationHandler(){

            @Override
            public void onSave() {
                LightEditTabs.this.saveDocument(editorInfo);
            }

            @Override
            public void onDiscard() {
                FileEditor fileEditor = editorInfo.getFileEditor();
                if (fileEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    FileDocumentManager.getInstance().reloadFromDisk(editor.getDocument());
                }
            }
        }))) {
            this.removeTab(tabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(editorInfo));
        }
    }

    private boolean autosaveDocument(@NotNull LightEditorInfo editorInfo) {
        if (LightEditService.getInstance().isAutosaveMode()) {
            this.saveDocument(editorInfo);
            return true;
        }
        return false;
    }

    void closeTab(@NotNull LightEditorInfo editorInfo) {
        TabInfo tabInfo = this.findInfo(editorInfo);
        if (tabInfo != null) {
            this.closeTab(tabInfo);
        }
    }

    void saveDocument(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo.isNew()) {
            VirtualFile targetFile = LightEditUtil.chooseTargetFile(this.getParent(), editorInfo);
            if (targetFile != null) {
                this.myEditorManager.saveAs(editorInfo, targetFile);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(editorInfo.getFile());
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
        }
    }

    void replaceTab(@NotNull LightEditorInfo oldInfo, @NotNull LightEditorInfo newInfo) {
        int oldIndex;
        TabInfo oldTabInfo = this.findInfo(oldInfo);
        if (oldTabInfo != null && (oldIndex = this.getIndexOf(oldTabInfo)) >= 0) {
            this.removeTab(oldTabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(oldInfo));
            this.addEditorTab(newInfo, oldIndex);
        }
    }

    @Nullable
    VirtualFile getSelectedFile() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = (LightEditorInfo)ObjectUtils.tryCast((Object)info.getObject(), LightEditorInfo.class)) != null) {
            return editorInfo.getFile();
        }
        return null;
    }

    @Nullable
    FileEditor getSelectedFileEditor() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = (LightEditorInfo)ObjectUtils.tryCast((Object)info.getObject(), LightEditorInfo.class)) != null) {
            return editorInfo.getFileEditor();
        }
        return null;
    }

    private void asyncUpdateTab(@NotNull TabInfo tabInfo) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        Object object = tabInfo.getObject();
        if (!(object instanceof LightEditorInfo)) {
            return;
        }
        this.asyncUpdateTabs(Collections.singletonList(Pair.createNonNull((Object)tabInfo, (Object)((LightEditorInfo)object))));
    }

    private void asyncUpdateTabs(@NotNull List<Pair.NonNull<TabInfo, LightEditorInfo>> tabEditorPairs) {
        this.myTabUpdateExecutor.execute(() -> {
            List tabAttributesPairs = ContainerUtil.map((Collection)tabEditorPairs, pair -> Pair.createNonNull((Object)pair.first, (Object)LightEditTabs.calcAttributes((LightEditorInfo)pair.second)));
            ApplicationManager.getApplication().invokeLater(() -> {
                for (Pair.NonNull attributesPair : tabAttributesPairs) {
                    this.updateTabPresentation((TabInfo)attributesPair.first, (TextAttributes)attributesPair.second);
                }
            });
        });
    }

    private void updateTabPresentation(@NotNull TabInfo tabInfo, @NotNull TextAttributes attributes) {
        tabInfo.setDefaultForeground(attributes.getForegroundColor());
        tabInfo.setTabColor(tabInfo == this.getSelectedInfo() ? attributes.getBackgroundColor() : null);
    }

    @NotNull
    private static TextAttributes calcAttributes(@NotNull LightEditorInfo editorInfo) {
        TextAttributes attributes = new TextAttributes();
        attributes.setBackgroundColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        LightEditTabAttributesProvider.EP_NAME.getExtensionList().forEach(provider -> {
            TextAttributes provided = provider.calcAttributes(editorInfo);
            if (provided != null) {
                if (provided.getForegroundColor() != null) {
                    attributes.setForegroundColor(provided.getForegroundColor());
                }
                if (provided.getBackgroundColor() != null) {
                    attributes.setBackgroundColor(provided.getBackgroundColor());
                }
            }
        });
        return attributes;
    }

    public void fileStatusChanged(@NotNull Collection<LightEditorInfo> editorInfos) {
        ApplicationManager.getApplication().invokeLater(() -> {
            List tabEditorPairs = ContainerUtil.mapNotNull((Collection)editorInfos, editorInfo -> {
                TabInfo info = this.findInfo(editorInfo);
                if (info == null) {
                    return null;
                }
                return Pair.createNonNull((Object)info, (Object)editorInfo);
            });
            if (!tabEditorPairs.isEmpty()) {
                this.asyncUpdateTabs(tabEditorPairs);
            }
        });
    }

    private class EditorContainer
    extends JPanel
    implements DataProvider {
        private EditorContainer(FileEditor editor) {
            super(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return LightEditUtil.getProject();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return LightEditTabs.this.getSelectedFile();
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                VirtualFile selectedFile = LightEditTabs.this.getSelectedFile();
                if (selectedFile != null) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = selectedFile;
                } else {
                    virtualFileArray = VirtualFile.EMPTY_ARRAY;
                }
                return virtualFileArray;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId)) {
                return LightEditTabs.this;
            }
            return null;
        }
    }

    private class CloseTabAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final LightEditorInfo myEditorInfo;
        private final Icon myUnsavedIcon = LightEditSaveStatusIcon.create(new Color(4228041));

        private CloseTabAction(LightEditorInfo editorInfo) {
            this.myEditorInfo = editorInfo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if ((e.getModifiers() & 8) == 0) {
                this.closeCurrentTab();
            } else {
                this.closeAllTabsExceptCurrent();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setIcon(this.getIcon());
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().getShowCloseButton());
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.LightEditTabs.text", (Object[])new Object[0]));
        }

        private Icon getIcon() {
            return this.myEditorInfo.isUnsaved() ? this.myUnsavedIcon : AllIcons.Actions.Close;
        }

        private void closeCurrentTab() {
            TabInfo tabInfo = LightEditTabs.this.findInfo(this.myEditorInfo);
            if (tabInfo != null) {
                LightEditTabs.this.closeTab(tabInfo);
            }
        }

        private void closeAllTabsExceptCurrent() {
            LightEditTabs.this.getTabs().stream().filter(tabInfo -> tabInfo != LightEditTabs.this.getSelectedInfo()).forEach(tabInfo -> LightEditTabs.this.closeTab(tabInfo));
        }
    }
}

