/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeEditor
extends SettingsEditor<AbstractFileType> {
    private final JTextField myFileTypeName = new JTextField();
    private final JTextField myFileTypeDescr = new JTextField();
    private final JCheckBox myIgnoreCase = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.ignore.case", (Object[])new Object[0]));
    private final JCheckBox mySupportBraces = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.braces", (Object[])new Object[0]));
    private final JCheckBox mySupportBrackets = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.brackets", (Object[])new Object[0]));
    private final JCheckBox mySupportParens = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.parens", (Object[])new Object[0]));
    private final JCheckBox mySupportEscapes = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.string.escapes", (Object[])new Object[0]));
    private final JTextField myLineComment = new JTextField(5);
    private final JCheckBox myCommentAtLineStart = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"&Only at line start"));
    private final JTextField myBlockCommentStart = new JTextField(5);
    private final JTextField myBlockCommentEnd = new JTextField(5);
    private final JTextField myHexPrefix = new JTextField(5);
    private final JTextField myNumPostfixes = new JTextField(5);
    private final JTextArea[] myKeywordsLists = new JTextArea[]{new JTextArea(), new JTextArea(), new JTextArea(), new JTextArea()};

    public CustomFileTypeEditor() {
        this.myLineComment.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                boolean enabled = StringUtil.isNotEmpty((String)CustomFileTypeEditor.this.myLineComment.getText());
                CustomFileTypeEditor.this.myCommentAtLineStart.setEnabled(enabled);
                if (!enabled) {
                    CustomFileTypeEditor.this.myCommentAtLineStart.setSelected(false);
                }
            }
        });
        this.myCommentAtLineStart.setEnabled(false);
    }

    public void resetEditorFrom(@NotNull AbstractFileType fileType) {
        this.myFileTypeName.setText(fileType.getName());
        this.myFileTypeDescr.setText(fileType.getDescription());
        SyntaxTable table = fileType.getSyntaxTable();
        if (table != null) {
            this.myLineComment.setText(table.getLineComment());
            this.myBlockCommentEnd.setText(table.getEndComment());
            this.myBlockCommentStart.setText(table.getStartComment());
            this.myHexPrefix.setText(table.getHexPrefix());
            this.myNumPostfixes.setText(table.getNumPostfixChars());
            this.myIgnoreCase.setSelected(table.isIgnoreCase());
            this.myCommentAtLineStart.setSelected(table.lineCommentOnlyAtStart);
            this.mySupportBraces.setSelected(table.isHasBraces());
            this.mySupportBrackets.setSelected(table.isHasBrackets());
            this.mySupportParens.setSelected(table.isHasParens());
            this.mySupportEscapes.setSelected(table.isHasStringEscapes());
            this.myKeywordsLists[0].setText(((StreamEx)StreamEx.of(table.getKeywords1()).sorted()).joining((CharSequence)"\n"));
            this.myKeywordsLists[1].setText(((StreamEx)StreamEx.of(table.getKeywords2()).sorted()).joining((CharSequence)"\n"));
            this.myKeywordsLists[2].setText(((StreamEx)StreamEx.of(table.getKeywords3()).sorted()).joining((CharSequence)"\n"));
            this.myKeywordsLists[3].setText(((StreamEx)StreamEx.of(table.getKeywords4()).sorted()).joining((CharSequence)"\n"));
            for (int i2 = 0; i2 < 4; ++i2) {
                this.myKeywordsLists[i2].setCaretPosition(0);
            }
        }
    }

    public void applyEditorTo(@NotNull AbstractFileType type) throws ConfigurationException {
        if (this.myFileTypeName.getText().trim().length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"error.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
        }
        if (this.myFileTypeDescr.getText().trim().length() == 0) {
            this.myFileTypeDescr.setText(this.myFileTypeName.getText());
        }
        type.setName(this.myFileTypeName.getText());
        type.setDescription(this.myFileTypeDescr.getText());
        type.setSyntaxTable(this.getSyntaxTable());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel fileTypePanel = new JPanel(new BorderLayout());
        JPanel info = FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.name", (Object[])new Object[0]), (JComponent)this.myFileTypeName).addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.description", (Object[])new Object[0]), (JComponent)this.myFileTypeDescr).getPanel();
        info.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        fileTypePanel.add((Component)info, "North");
        JPanel highlighterPanel = new JPanel();
        highlighterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.customfiletype.syntax.highlighting", (Object[])new Object[0]), (boolean)false));
        highlighterPanel.setLayout(new BorderLayout());
        JPanel commentsAndNumbersPanel = new JPanel();
        commentsAndNumbersPanel.setLayout(new GridBagLayout());
        JPanel _panel1 = new JPanel(new BorderLayout());
        GridBag gb = new GridBag().setDefaultFill(2).setDefaultAnchor(17).setDefaultInsets(1, 5, 1, 5);
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.line.comment", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myLineComment, gb.next());
        commentsAndNumbersPanel.add((Component)this.myCommentAtLineStart, gb.next().coverLine(2));
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.start", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentStart, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.end", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentEnd, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.hex.prefix", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myHexPrefix, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.number.postfixes", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myNumPostfixes, gb.next());
        commentsAndNumbersPanel.add((Component)this.mySupportBraces, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportBrackets, gb.next().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportParens, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportEscapes, gb.next().next().coverLine(2));
        _panel1.add((Component)commentsAndNumbersPanel, "West");
        highlighterPanel.add((Component)_panel1, "North");
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
        tabbedPaneWrapper.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"listbox.customfiletype.keywords", (Object[])new Object[0]), (boolean)false));
        for (int i2 = 0; i2 < 4; ++i2) {
            JTextArea list2 = this.myKeywordsLists[i2];
            list2.setRows(10);
            tabbedPaneWrapper.addTab(" " + (i2 + 1) + " ", (JComponent)new JBScrollPane((Component)list2));
        }
        highlighterPanel.add((Component)tabbedPaneWrapper.getComponent(), "Center");
        highlighterPanel.add((Component)this.myIgnoreCase, "South");
        fileTypePanel.add((Component)highlighterPanel, "Center");
        panel2.add(fileTypePanel);
        return panel2;
    }

    @NotNull
    public SyntaxTable getSyntaxTable() {
        SyntaxTable syntaxTable = new SyntaxTable();
        syntaxTable.setLineComment(this.myLineComment.getText());
        syntaxTable.setStartComment(this.myBlockCommentStart.getText());
        syntaxTable.setEndComment(this.myBlockCommentEnd.getText());
        syntaxTable.setHexPrefix(this.myHexPrefix.getText());
        syntaxTable.setNumPostfixChars(this.myNumPostfixes.getText());
        syntaxTable.lineCommentOnlyAtStart = this.myCommentAtLineStart.isSelected();
        boolean ignoreCase = this.myIgnoreCase.isSelected();
        syntaxTable.setIgnoreCase(ignoreCase);
        syntaxTable.setHasBraces(this.mySupportBraces.isSelected());
        syntaxTable.setHasBrackets(this.mySupportBrackets.isSelected());
        syntaxTable.setHasParens(this.mySupportParens.isSelected());
        syntaxTable.setHasStringEscapes(this.mySupportEscapes.isSelected());
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[0]).forEach(syntaxTable::addKeyword1);
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[1]).forEach(syntaxTable::addKeyword2);
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[2]).forEach(syntaxTable::addKeyword3);
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[3]).forEach(syntaxTable::addKeyword4);
        return syntaxTable;
    }

    private static Stream<String> splitKeywordLines(boolean ignoreCase, JTextArea list2) {
        return Arrays.stream(StringUtil.splitByLines((String)list2.getText())).map(s -> ignoreCase ? s.toLowerCase(Locale.getDefault()) : s);
    }
}

