/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="HierarchyBrowserManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class HierarchyBrowserManager
implements PersistentStateComponent<State> {
    private State myState = new State();
    private final ContentManager myContentManager;

    public HierarchyBrowserManager(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow("Hierarchy", true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
        this.myContentManager = toolWindow.getContentManager();
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowHierarchy);
        ContentManagerWatcher.watchContentManager(toolWindow, this.myContentManager);
    }

    public final ContentManager getContentManager() {
        return this.myContentManager;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public static HierarchyBrowserManager getInstance(@NotNull Project project) {
        return (HierarchyBrowserManager)ServiceManager.getService((Project)project, HierarchyBrowserManager.class);
    }

    public static State getSettings(@NotNull Project project) {
        State state = HierarchyBrowserManager.getInstance(project).getState();
        return state != null ? state : new State();
    }

    public static class State {
        public boolean IS_AUTOSCROLL_TO_SOURCE;
        public boolean SORT_ALPHABETICALLY;
        public boolean HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED;
        public String SCOPE;
        public String EXPORT_FILE_PATH;
    }
}

