/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExportableFileTemplateSettings", storages={@Storage(value="file.template.settings.xml")})
class FileTemplateSettings
extends FileTemplatesLoader
implements PersistentStateComponent<Element> {
    static final String EXPORTABLE_SETTINGS_FILE = "file.template.settings.xml";
    private static final String ELEMENT_TEMPLATE = "template";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_REFORMAT = "reformat";
    private static final String ATTRIBUTE_LIVE_TEMPLATE = "live-template-enabled";
    private static final String ATTRIBUTE_ENABLED = "enabled";

    FileTemplateSettings(@Nullable Project project) {
        super(project);
    }

    @Nullable
    public Element getState() {
        Element element2 = new Element("fileTemplateSettings");
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = null;
            for (FileTemplateBase template : manager.getAllTemplates(true)) {
                boolean shouldSave;
                boolean bl = shouldSave = !template.isReformatCode() || template.isLiveTemplateEnabledChanged() && template.isLiveTemplateEnabled() != template.isLiveTemplateEnabledByDefault();
                if (template instanceof BundledFileTemplate) {
                    shouldSave |= !((BundledFileTemplate)template).isEnabled();
                }
                if (!shouldSave) continue;
                Element templateElement = new Element(ELEMENT_TEMPLATE);
                templateElement.setAttribute(ATTRIBUTE_NAME, template.getQualifiedName());
                templateElement.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isReformatCode()));
                templateElement.setAttribute(ATTRIBUTE_LIVE_TEMPLATE, Boolean.toString(template.isLiveTemplateEnabled()));
                if (template instanceof BundledFileTemplate) {
                    templateElement.setAttribute(ATTRIBUTE_ENABLED, Boolean.toString(((BundledFileTemplate)template).isEnabled()));
                }
                if (templatesGroup == null) {
                    templatesGroup = new Element(FileTemplateSettings.getXmlElementGroupName(manager));
                    element2.addContent(templatesGroup);
                }
                templatesGroup.addContent(templateElement);
            }
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = state.getChild(FileTemplateSettings.getXmlElementGroupName(manager));
            if (templatesGroup == null) continue;
            for (Element child2 : templatesGroup.getChildren(ELEMENT_TEMPLATE)) {
                String qName = child2.getAttributeValue(ATTRIBUTE_NAME);
                FileTemplateBase template = manager.getTemplate(qName);
                if (template == null) continue;
                template.setReformatCode(Boolean.parseBoolean(child2.getAttributeValue(ATTRIBUTE_REFORMAT)));
                template.setLiveTemplateEnabled(Boolean.parseBoolean(child2.getAttributeValue(ATTRIBUTE_LIVE_TEMPLATE)));
                if (!(template instanceof BundledFileTemplate)) continue;
                ((BundledFileTemplate)template).setEnabled(Boolean.parseBoolean(child2.getAttributeValue(ATTRIBUTE_ENABLED, "true")));
            }
        }
    }

    private static String getXmlElementGroupName(@NotNull FTManager manager) {
        return StringUtil.toLowerCase((String)manager.getName()) + "_templates";
    }
}

