/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AddAllOpenFilesToFavorites
extends AnAction
implements DumbAware {
    private final String myFavoritesName;

    public AddAllOpenFilesToFavorites(String chosenList) {
        this.getTemplatePresentation().setText(chosenList, false);
        this.myFavoritesName = chosenList;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        ArrayList<PsiFile> filesToAdd = AddAllOpenFilesToFavorites.getFilesToAdd(project);
        for (PsiFile file2 : filesToAdd) {
            favoritesManager.addRoots(this.myFavoritesName, null, file2);
        }
    }

    static ArrayList<PsiFile> getFilesToAdd(Project project) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile openFile2 : editorManager.getOpenFiles()) {
            PsiFile psiFile;
            if (!openFile2.isValid() || (psiFile = psiManager.findFile(openFile2)) == null) continue;
            result2.add(psiFile);
        }
        return result2;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(!AddAllOpenFilesToFavorites.getFilesToAdd(project).isEmpty());
    }
}

