/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class TaskDefaultFavoriteListProvider
extends AbstractFavoritesListProvider {
    public static final String CURRENT_TASK = "Current task";

    public TaskDefaultFavoriteListProvider(Project project) {
        super(project, CURRENT_TASK);
    }

    @Override
    public FavoritesListNode createFavoriteListNode(Project project) {
        return null;
    }

    @Override
    public int getWeight() {
        return 300;
    }

    public static List<AbstractTreeNode<?>> getPathToUsualNode(AbstractTreeNode treeNode) {
        ArrayList result2 = new ArrayList();
        for (AbstractTreeNode current2 = treeNode; current2 != null && !(current2 instanceof FavoritesRootNode); current2 = current2.getParent()) {
            result2.add(current2);
        }
        Collections.reverse(result2);
        return result2;
    }

    public static List<AbstractTreeNode<?>> getPathToUsualNode(AbstractTreeNode treeNode, Tree tree) {
        AbstractTreeNode parent = treeNode.getParent();
        if (parent instanceof ProjectViewNodeWithChildrenList) {
            List<AbstractTreeNode<?>> pathToSelected = FavoritesTreeUtil.getLogicalPathToSelected(tree);
            if (pathToSelected.isEmpty()) {
                return pathToSelected;
            }
            return pathToSelected.subList(0, pathToSelected.size() - 1);
        }
        return Collections.emptyList();
    }

    private void showNotePopup(Project project, DnDAwareTree tree, final Consumer<? super String> after2, String initText) {
        final JTextArea textArea = new JTextArea(3, 50);
        textArea.setFont(UIUtil.getTreeFont());
        textArea.setText(initText);
        JBScrollPane pane2 = new JBScrollPane((Component)textArea);
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)pane2, (JComponent)textArea).setCancelOnClickOutside(true).setAdText(LangBundle.message((String)"popup.advertisement.to.finish", (Object[])new Object[]{KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts())})).setTitle(LangBundle.message((String)"popup.title.comment", (Object[])new Object[0])).setMovable(true).setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup2 = builder2.createPopup();
        final JComponent content2 = popup2.getContent();
        AnAction action2 = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                popup2.closeOk(e.getInputEvent());
                this.unregisterCustomShortcutSet(content2);
                after2.consume((Object)textArea.getText());
            }
        };
        action2.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, content2);
        ApplicationManager.getApplication().invokeLater(() -> popup2.showInCenterOf((Component)((Object)tree)), ModalityState.NON_MODAL, project.getDisposed());
    }
}

