/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.FixedHotfixGroupElement;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.HotfixGroupElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorViewStructure
extends AbstractTreeStructure {
    private final ErrorTreeElement myRoot = new MyRootElement();
    private final List<String> myGroupNames = new ArrayList<String>();
    private final Map<String, GroupingElement> myGroupNameToElementMap = new HashMap<String, GroupingElement>();
    private final Map<String, List<NavigatableMessageElement>> myGroupNameToMessagesMap = new HashMap<String, List<NavigatableMessageElement>>();
    private final Map<ErrorTreeElementKind, List<ErrorTreeElement>> mySimpleMessages = new EnumMap<ErrorTreeElementKind, List<ErrorTreeElement>>(ErrorTreeElementKind.class);
    private final Object myLock = new Object();
    private static final ErrorTreeElementKind[] ourMessagesOrder = new ErrorTreeElementKind[]{ErrorTreeElementKind.INFO, ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE, ErrorTreeElementKind.GENERIC};
    private final Project myProject;
    private final boolean myCanHideWarnings;

    public ErrorViewStructure(Project project, boolean canHideWarnings) {
        this.myProject = project;
        this.myCanHideWarnings = canHideWarnings;
    }

    @NotNull
    public Object getRootElement() {
        return this.myRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                List<ErrorTreeElement> elements2 = entry.getValue();
                if (elements2 == null || elements2.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages(@NotNull Set<ErrorTreeElementKind> kinds) {
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> messages;
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                if (!kinds.contains(entry.getKey()) || (messages = entry.getValue()) == null || messages.isEmpty()) continue;
                return true;
            }
            for (Map.Entry<Object, List<ErrorTreeElement>> entry : this.myGroupNameToMessagesMap.entrySet()) {
                messages = entry.getValue();
                if (messages == null || messages.isEmpty()) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kinds.contains(navigatableMessageElement.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement @NotNull [] getChildElements(@NotNull Object element2) {
        if (element2 == this.myRoot) {
            ArrayList<ErrorTreeElement> children2 = new ArrayList<ErrorTreeElement>();
            Object object = this.myLock;
            synchronized (object) {
                for (ErrorTreeElementKind kind : ourMessagesOrder) {
                    List<ErrorTreeElement> elems;
                    if (this.shouldHide(kind) || (elems = this.mySimpleMessages.get(kind)) == null) continue;
                    children2.addAll(elems);
                }
                for (String myGroupName : this.myGroupNames) {
                    GroupingElement groupingElement = this.myGroupNameToElementMap.get(myGroupName);
                    if (!this.shouldShowFileElement(groupingElement)) continue;
                    children2.add(groupingElement);
                }
            }
            return children2.toArray(ErrorTreeElement.EMPTY_ARRAY);
        }
        if (element2 instanceof GroupingElement) {
            Object object = this.myLock;
            synchronized (object) {
                List<NavigatableMessageElement> children3 = this.myGroupNameToMessagesMap.get(((GroupingElement)element2).getName());
                if (children3 != null && !children3.isEmpty()) {
                    if (this.isFilteringNeeded()) {
                        ArrayList<NavigatableMessageElement> filtered2 = new ArrayList<NavigatableMessageElement>(children3.size());
                        for (NavigatableMessageElement navigatableMessageElement : children3) {
                            if (this.shouldHide(navigatableMessageElement.getKind())) continue;
                            filtered2.add(navigatableMessageElement);
                        }
                        return filtered2.toArray(ErrorTreeElement.EMPTY_ARRAY);
                    }
                    return children3.toArray(new NavigatableMessageElement[0]);
                }
            }
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    private boolean isFilteringNeeded() {
        if (!this.myCanHideWarnings) {
            return false;
        }
        ErrorTreeViewConfiguration config2 = ErrorTreeViewConfiguration.getInstance(this.myProject);
        return config2.isHideWarnings() || config2.isHideInfoMessages();
    }

    private boolean shouldHide(ErrorTreeElementKind kind) {
        if (!this.myCanHideWarnings) {
            return false;
        }
        switch (kind) {
            case WARNING: 
            case NOTE: {
                return ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings();
            }
            case INFO: {
                return ErrorTreeViewConfiguration.getInstance(this.myProject).isHideInfoMessages();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShowFileElement(GroupingElement groupingElement) {
        if (!this.isFilteringNeeded()) {
            return this.getChildCount(groupingElement) > 0;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            if (children2 != null) {
                for (NavigatableMessageElement child2 : children2) {
                    if (this.shouldHide(child2.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getParentElement(@NotNull Object element2) {
        if (element2 instanceof GroupingElement || element2 instanceof SimpleMessageElement) {
            return this.myRoot;
        }
        if (element2 instanceof NavigatableMessageElement) {
            GroupingElement result2 = ((NavigatableMessageElement)element2).getParent();
            return result2 == null ? this.myRoot : result2;
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        return new ErrorTreeNodeDescriptor(this.myProject, parentDescriptor, (ErrorTreeElement)element2);
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public ErrorTreeElement addMessage(@NotNull ErrorTreeElementKind kind, String @NotNull [] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        if (underFileGroup != null || file2 != null) {
            if (file2 == null) {
                column = -1;
                line = -1;
            }
            int guiline = line < 0 ? -1 : line + 1;
            int guicolumn = column < 0 ? -1 : column + 1;
            VirtualFile group = underFileGroup != null ? underFileGroup : file2;
            VirtualFile nav = file2 != null ? file2 : underFileGroup;
            return this.addNavigatableMessage(group.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text, data2, NewErrorTreeViewPanel.createExportPrefix(guiline), NewErrorTreeViewPanel.createRendererPrefix(guiline, guicolumn), group);
        }
        return this.addSimpleMessage(kind, text, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getGroupChildrenData(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupName);
            if (children2 == null || children2.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (NavigatableMessageElement child2 : children2) {
                Object data2 = child2.getData();
                if (data2 == null) continue;
                result2.add(data2);
            }
            return result2;
        }
    }

    public void addFixedHotfixGroup(String text, List<? extends SimpleErrorData> children2) {
        FixedHotfixGroupElement group = new FixedHotfixGroupElement(text, null, null);
        this.addGroupPlusElements(text, group, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<? extends SimpleErrorData> children2, MutableErrorTreeView view) {
        String text = hotfixData.getErrorText();
        HotfixGroupElement group = new HotfixGroupElement(text, null, null, (Consumer<? super HotfixGate>)hotfixData.getFix(), hotfixData.getFixComment(), view);
        this.addGroupPlusElements(text, group, children2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupPlusElements(String text, GroupingElement group, List<? extends SimpleErrorData> children2) {
        ArrayList<MyNavigatableWithDataElement> elements2 = new ArrayList<MyNavigatableWithDataElement>();
        for (SimpleErrorData simpleErrorData : children2) {
            elements2.add(new MyNavigatableWithDataElement(this.myProject, simpleErrorData.getKind(), group, simpleErrorData.getMessages(), simpleErrorData.getVf(), NewErrorTreeViewPanel.createExportPrefix(-1), NewErrorTreeViewPanel.createRendererPrefix(-1, -1)));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.add(text);
            this.myGroupNameToElementMap.put(text, group);
            this.myGroupNameToMessagesMap.put(text, elements2);
        }
    }

    public ErrorTreeElement addMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data2) {
        return this.addSimpleMessage(kind, text, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NavigatableMessageElement> removeNavigatableMessage(@NotNull String groupName, @NotNull ErrorTreeElementKind kind, @NotNull Navigatable navigatable) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements2 = this.myGroupNameToMessagesMap.get(groupName);
            if (elements2 == null) {
                return Collections.emptyList();
            }
            int i2 = 0;
            ArrayList<NavigatableMessageElement> removed = new ArrayList<NavigatableMessageElement>();
            while (i2 < elements2.size()) {
                NavigatableMessageElement element2 = elements2.get(i2);
                if (element2.getNavigatable() == navigatable && element2.getKind() == kind) {
                    removed.add(element2);
                    elements2.remove(i2);
                    continue;
                }
                ++i2;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NavigatableMessageElement> removeAllNavigatableMessagesInGroup(@NotNull String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements2 = this.myGroupNameToMessagesMap.get(groupName);
            if (elements2 == null) {
                return Collections.emptyList();
            }
            ArrayList<NavigatableMessageElement> removed = new ArrayList<NavigatableMessageElement>(elements2);
            elements2.clear();
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement addNavigatableMessage(@Nullable String groupName, Navigatable navigatable, @NotNull ErrorTreeElementKind kind, String[] message, Object data2, String exportText, String rendererTextPrefix, VirtualFile file2) {
        if (groupName == null) {
            return this.addSimpleMessageElement(new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements2 = this.myGroupNameToMessagesMap.get(groupName);
            if (elements2 == null) {
                elements2 = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements2);
            }
            NavigatableMessageElement element2 = new NavigatableMessageElement(kind, this.getGroupingElement(groupName, data2, file2), message, navigatable, exportText, rendererTextPrefix);
            elements2.add(element2);
            return element2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@NotNull String groupName, @NotNull NavigatableMessageElement navigatableMessageElement) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements2 = this.myGroupNameToMessagesMap.get(groupName);
            if (elements2 == null) {
                elements2 = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements2);
            }
            if (!this.myGroupNameToElementMap.containsKey(groupName)) {
                this.myGroupNames.add(groupName);
                this.myGroupNameToElementMap.put(groupName, navigatableMessageElement.getParent());
            }
            elements2.add(navigatableMessageElement);
        }
    }

    private ErrorTreeElement addSimpleMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data2) {
        return this.addSimpleMessageElement(new SimpleMessageElement(kind, text, data2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement addSimpleMessageElement(ErrorTreeElement element2) {
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> elements2 = this.mySimpleMessages.get(element2.getKind());
            if (elements2 == null) {
                elements2 = new ArrayList<ErrorTreeElement>();
                this.mySimpleMessages.put(element2.getKind(), elements2);
            }
            elements2.add(element2);
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GroupingElement lookupGroupingElement(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGroupNameToElementMap.get(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupingElement getGroupingElement(String groupName, Object data2, VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            GroupingElement element2 = this.myGroupNameToElementMap.get(groupName);
            if (element2 != null) {
                return element2;
            }
            element2 = this.createGroupingElement(groupName, data2, file2);
            this.myGroupNames.add(groupName);
            this.myGroupNameToElementMap.put(groupName, element2);
            return element2;
        }
    }

    @NotNull
    protected GroupingElement createGroupingElement(String groupName, Object data2, VirtualFile file2) {
        return new GroupingElement(groupName, data2, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(GroupingElement groupingElement) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            return children2 == null ? 0 : children2.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.clear();
            this.myGroupNameToElementMap.clear();
            this.myGroupNameToMessagesMap.clear();
            this.mySimpleMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        if (this.shouldHide(kind)) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> simpleMessages = this.mySimpleMessages.get(kind);
            if (simpleMessages != null && !simpleMessages.isEmpty()) {
                return simpleMessages.get(0);
            }
            for (String path : this.myGroupNames) {
                List<NavigatableMessageElement> messages = this.myGroupNameToMessagesMap.get(path);
                if (messages == null) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kind.equals((Object)navigatableMessageElement.getKind())) continue;
                    return navigatableMessageElement;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.remove(name);
            this.myGroupNameToElementMap.remove(name);
            this.myGroupNameToMessagesMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ErrorTreeElement element2) {
        if (element2 == this.myRoot) {
            return;
        }
        if (element2 instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element2;
            this.removeGroup(groupingElement.getName());
            VirtualFile virtualFile = groupingElement.getFile();
            if (virtualFile != null) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiFile psiFile;
                    PsiFile psiFile2 = psiFile = virtualFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(virtualFile) : null;
                    if (psiFile != null) {
                        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
                    }
                });
            }
        } else if (element2 instanceof NavigatableMessageElement) {
            NavigatableMessageElement navElement = (NavigatableMessageElement)element2;
            GroupingElement parent = navElement.getParent();
            if (parent != null) {
                Object object = this.myLock;
                synchronized (object) {
                    List<NavigatableMessageElement> groupMessages = this.myGroupNameToMessagesMap.get(parent.getName());
                    if (groupMessages != null) {
                        groupMessages.remove(navElement);
                    }
                }
            }
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<ErrorTreeElement> simples = this.mySimpleMessages.get(element2.getKind());
                if (simples != null) {
                    simples.remove(element2);
                }
            }
        }
    }

    private static class MyNavigatableWithDataElement
    extends NavigatableMessageElement {
        private final VirtualFile myVf;
        private final CustomizeColoredTreeCellRenderer myCustomizeColoredTreeCellRenderer;

        private MyNavigatableWithDataElement(Project project, @NotNull ErrorTreeElementKind kind, GroupingElement parent, String[] message, final @NotNull VirtualFile vf, String exportText, String rendererTextPrefix) {
            super(kind, parent, message, (Navigatable)new OpenFileDescriptor(project, vf, -1, -1), exportText, rendererTextPrefix);
            this.myVf = vf;
            this.myCustomizeColoredTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Icon icon2 = myVf.getFileType().getIcon();
                    renderer.setIcon(icon2);
                    String[] messages = this.getText();
                    String text = messages == null || messages.length == 0 ? vf.getPath() : messages[0];
                    renderer.append(text);
                }
            };
        }

        @Override
        public Object getData() {
            return this.myVf;
        }

        @Override
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myCustomizeColoredTreeCellRenderer;
        }
    }

    private static class MyRootElement
    extends ErrorTreeElement {
        private MyRootElement() {
        }

        @Override
        public String[] getText() {
            return null;
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public String getExportTextPrefix() {
            return "";
        }
    }
}

