/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.net.HostAndPort;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStarter {
    private static final Logger LOG = Logger.getInstance(BrowserStarter.class);
    private final StartBrowserSettings mySettings;
    private final RunConfiguration myRunConfiguration;
    private final BooleanSupplier myOutdated;

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings, @NotNull BooleanSupplier outdated) {
        this.mySettings = settings;
        this.myRunConfiguration = runConfiguration;
        this.myOutdated = outdated;
    }

    public BrowserStarter(@NotNull RunConfiguration runConfiguration, @NotNull StartBrowserSettings settings, @NotNull ProcessHandler serverProcessHandler) {
        this(runConfiguration, settings, () -> serverProcessHandler.isProcessTerminating() || serverProcessHandler.isProcessTerminated());
    }

    public void start() {
        if (!this.mySettings.isSelected() || this.mySettings.getUrl() == null) {
            return;
        }
        HostAndPort hostAndPort = BrowserStarter.getHostAndPort(this.mySettings.getUrl());
        if (hostAndPort != null) {
            this.checkAndOpenPageLater(hostAndPort, 1, 300);
        } else {
            this.openPageLater();
        }
    }

    @Nullable
    private static HostAndPort getHostAndPort(@NotNull String rawUrl) {
        URI url = Urls.parseAsJavaUriWithoutParameters((String)rawUrl);
        if (url == null) {
            return null;
        }
        int port = url.getPort();
        if (port == -1) {
            port = "https".equals(url.getScheme()) ? 443 : 80;
        }
        return HostAndPort.fromParts((String)StringUtil.notNullize((String)url.getHost(), (String)"127.0.0.1"), (int)port);
    }

    private void checkAndOpenPageLater(@NotNull HostAndPort hostAndPort, int attemptNumber, int delayMillis) {
        JobScheduler.getScheduler().schedule(() -> this.checkAndOpenPage(hostAndPort, attemptNumber), (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private void checkAndOpenPage(@NotNull HostAndPort hostAndPort, int attemptNumber) {
        if (this.isOutdated()) {
            LOG.info("Opening " + hostAndPort + " aborted");
        } else if (NetUtils.canConnectToRemoteSocket((String)hostAndPort.getHost(), (int)hostAndPort.getPort())) {
            this.openPageNow();
        } else if (attemptNumber < 100) {
            int delayMillis = BrowserStarter.getDelayMillis(attemptNumber);
            LOG.info("#" + attemptNumber + " check " + hostAndPort + " failed, scheduling next check in " + delayMillis + "ms");
            this.checkAndOpenPageLater(hostAndPort, attemptNumber + 1, delayMillis);
        } else {
            LOG.info("#" + attemptNumber + " check " + hostAndPort + " failed. Too many failed checks. Failed to open " + hostAndPort);
            this.showBrowserOpenTimeoutNotification();
        }
    }

    private static int getDelayMillis(int attemptNumber) {
        if (attemptNumber < 10) {
            return 500;
        }
        if (attemptNumber < 20) {
            return 1000;
        }
        return 5000;
    }

    private void openPageLater() {
        JobScheduler.getScheduler().schedule(() -> this.openPageNow(), 1000L, TimeUnit.MILLISECONDS);
    }

    private void openPageNow() {
        if (!this.isOutdated()) {
            JavaScriptDebuggerStarter.Util.startDebugOrLaunchBrowser(this.myRunConfiguration, this.mySettings);
        }
    }

    private boolean isOutdated() {
        return this.myOutdated.getAsBoolean();
    }

    private void showBrowserOpenTimeoutNotification() {
        NotificationGroup group = NotificationGroup.balloonGroup((String)"URL does not respond notification", (String)IdeBundle.message((String)"browser.notification.timeout.group", (Object[])new Object[0]));
        NotificationType type = NotificationType.ERROR;
        String title = IdeBundle.message((String)"browser.notification.timeout.title", (Object[])new Object[0]);
        String url = Objects.requireNonNull(this.mySettings.getUrl());
        String openUrlDescription = "open_url";
        String content2 = IdeBundle.message((String)"browser.notification.timeout.text", (Object[])new Object[]{openUrlDescription, url});
        Notification openBrowserNotification = group.createNotification(title, content2, type, (notification, event) -> {
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (event.getDescription().equals(openUrlDescription)) {
                BrowserUtil.open((String)url);
                notification.expire();
            }
        });
        openBrowserNotification.notify(this.myRunConfiguration.getProject());
    }
}

