/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksFavoriteListProvider
extends AbstractFavoritesListProvider<Bookmark>
implements BookmarksListener {
    public BookmarksFavoriteListProvider(Project project) {
        super(project, "Bookmarks");
        project.getMessageBus().connect().subscribe(BookmarksListener.TOPIC, (Object)this);
        this.updateChildren();
    }

    @Override
    public void bookmarkAdded(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkRemoved(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkChanged(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarksOrderChanged() {
        this.updateChildren();
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        List<Bookmark> bookmarks = BookmarkManager.getInstance(this.myProject).getValidBookmarks();
        for (final Bookmark bookmark : bookmarks) {
            AbstractTreeNode<Bookmark> child2 = new AbstractTreeNode<Bookmark>(this.myProject, bookmark){

                @NotNull
                public Collection<? extends AbstractTreeNode<Bookmark>> getChildren() {
                    return Collections.emptyList();
                }

                public boolean canNavigate() {
                    return bookmark.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return bookmark.canNavigateToSource();
                }

                public void navigate(boolean requestFocus) {
                    bookmark.navigate(requestFocus);
                }

                protected void update(@NotNull PresentationData presentation2) {
                    presentation2.setPresentableText(bookmark.toString());
                    presentation2.setIcon(bookmark.getIcon());
                }
            };
            child2.setParent((AbstractTreeNode)this.myNode);
            this.myChildren.add(child2);
        }
        FavoritesManager.getInstance(this.myProject).fireListeners(this.getListName(this.myProject));
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        switch (type) {
            case EDIT: {
                return IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]);
            }
            case REMOVE: {
                return IdeBundle.message((String)"action.bookmark.delete", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        switch (type) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                Object toEdit = selectedObjects.iterator().next();
                return toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    if (toRemove2 instanceof AbstractTreeNode && ((AbstractTreeNode)toRemove2).getValue() instanceof Bookmark) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component2) {
        switch (type) {
            case EDIT: {
                Bookmark bookmark;
                Object toEdit;
                if (selectedObjects.size() != 1 || !((toEdit = selectedObjects.iterator().next()) instanceof AbstractTreeNode) || !(((AbstractTreeNode)toEdit).getValue() instanceof Bookmark) || (bookmark = (Bookmark)((AbstractTreeNode)toEdit).getValue()) == null) break;
                BookmarkManager.getInstance(project).editDescription(bookmark, component2);
                break;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toRemove2).getValue();
                    BookmarkManager.getInstance(project).removeBookmark(bookmark);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.clear();
        renderer.setIcon(Bookmark.DEFAULT_ICON);
        if (value2 instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)value2;
            BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, this.myProject, bookmark, selected2);
            if (renderer.getIcon() != null) {
                RowIcon icon2 = IconManager.getInstance().createRowIcon(3, RowIcon.Alignment.CENTER);
                icon2.setIcon(bookmark.getIcon(), 0);
                icon2.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1)), 1);
                icon2.setIcon(renderer.getIcon(), 2);
                renderer.setIcon((Icon)icon2);
            } else {
                renderer.setIcon(bookmark.getIcon());
            }
        } else {
            renderer.append(this.getListName(this.myProject));
        }
    }
}

