/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class BookmarkManager
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final MultiMap<VirtualFile, Bookmark> myBookmarks = MultiMap.createConcurrentSet();
    private final Map<Trinity<VirtualFile, Integer, String>, Bookmark> myDeletedDocumentBookmarks = new HashMap<Trinity<VirtualFile, Integer, String>, Bookmark>();
    private final Map<Document, List<Trinity<Bookmark, Integer, String>>> myBeforeChangeData = new HashMap<Document, List<Trinity<Bookmark, Integer, String>>>();
    private final Project myProject;
    private boolean mySortedState;
    private final AtomicReference<List<Bookmark>> myPendingState = new AtomicReference();

    public static BookmarkManager getInstance(@NotNull Project project) {
        return (BookmarkManager)ServiceManager.getService((Project)project, BookmarkManager.class);
    }

    public BookmarkManager(@NotNull Project project) {
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.colorsChanged());
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
        multicaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this.myProject);
        this.mySortedState = UISettings.getInstance().getSortBookmarks();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (this.mySortedState != uiSettings.getSortBookmarks()) {
                this.mySortedState = uiSettings.getSortBookmarks();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!project.isDisposed()) {
                        ((BookmarksListener)project.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged();
                    }
                });
            }
        });
    }

    public void editDescription(@NotNull Bookmark bookmark, @NotNull JComponent popup2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String description = Messages.showInputDialog((Component)popup2, (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)bookmark.getDescription(), null);
        if (description != null) {
            this.setDescription(bookmark, description);
        }
    }

    public void addEditorBookmark(@NotNull Editor editor, int lineIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file2, int lineIndex, @NotNull String description) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark b = new Bookmark(this.myProject, file2, lineIndex, description);
        this.myBookmarks.values().forEach(bookmark -> ++bookmark.index);
        this.myBookmarks.putValue((Object)file2, (Object)b);
        this.getPublisher().bookmarkAdded(b);
        return b;
    }

    @NotNull
    private BookmarksListener getPublisher() {
        return (BookmarksListener)this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC);
    }

    public void addFileBookmark(@NotNull VirtualFile file2, @NotNull String description) {
        if (this.findFileBookmark(file2) != null) {
            return;
        }
        this.addTextBookmark(file2, -1, description);
    }

    @NotNull
    private static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription = editor.getSelectionModel().getSelectedText();
        if (autoDescription == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            return autoDescription.substring(0, 50) + "...";
        }
        return autoDescription;
    }

    @NotNull
    public List<Bookmark> getValidBookmarks() {
        List answer = ContainerUtil.filter((Collection)this.myBookmarks.values(), b -> b.isValid());
        if (UISettings.getInstance().getSortBookmarks()) {
            Collections.sort(answer);
        } else {
            answer.sort(Comparator.comparingInt(b -> b.index));
        }
        return answer;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return null;
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == line);
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file2) {
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == -1);
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() == mm);
    }

    public boolean hasBookmarksWithMnemonics() {
        return ContainerUtil.or((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() != '\u0000');
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile file2 = bookmark.getFile();
        if (this.myBookmarks.remove((Object)file2, (Object)bookmark)) {
            int index = bookmark.index;
            this.myBookmarks.values().forEach(b -> {
                b.index = b.index - (b.index > index ? 1 : 0);
            });
            bookmark.release();
            this.getPublisher().bookmarkRemoved(bookmark);
        }
    }

    public Element getState() {
        Element container2 = new Element("BookmarkManager");
        this.writeExternal(container2);
        return container2;
    }

    public void loadState(@NotNull Element state) {
        this.myPendingState.set(BookmarkManager.readExternal(state));
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
            List newList = this.myPendingState.getAndSet(null);
            if (newList != null) {
                this.applyNewState(newList, true);
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed()));
    }

    public void applyNewStateInTestMode(@NotNull List<Bookmark> newList) {
        this.applyNewState(newList, false);
    }

    private void applyNewState(@NotNull List<Bookmark> newList, boolean fireEvents) {
        if (!this.myBookmarks.isEmpty()) {
            Bookmark[] bookmarks;
            for (Bookmark bookmark : bookmarks = this.myBookmarks.values().toArray(new Bookmark[0])) {
                bookmark.release();
            }
            this.myBookmarks.clear();
        }
        int bookmarkIndex = newList.size() - 1;
        ArrayList<Bookmark> addedBookmarks = new ArrayList<Bookmark>(newList.size());
        for (Bookmark bookmark : newList) {
            Bookmark old;
            OpenFileDescriptor target2 = bookmark.init(this.myProject);
            if (target2 == null || target2.getLine() == -1 && this.findFileBookmark(target2.getFile()) != null) continue;
            bookmark.index = bookmarkIndex--;
            char mnemonic = bookmark.getMnemonic();
            if (mnemonic != '\u0000' && (old = this.findBookmarkForMnemonic(mnemonic)) != null) {
                this.removeBookmark(old);
            }
            this.myBookmarks.putValue((Object)target2.getFile(), (Object)bookmark);
            addedBookmarks.add(bookmark);
        }
        if (fireEvents) {
            for (Bookmark bookmark : addedBookmarks) {
                this.getPublisher().bookmarkAdded(bookmark);
            }
        }
    }

    @NotNull
    private static List<Bookmark> readExternal(@NotNull Element element2) {
        ArrayList<Bookmark> result2 = new ArrayList<Bookmark>();
        for (Element bookmarkElement : element2.getChildren("bookmark")) {
            String url = bookmarkElement.getAttributeValue("url");
            if (StringUtil.isEmptyOrSpaces((String)url)) continue;
            String line = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            int lineIndex = -1;
            if (line != null) {
                try {
                    lineIndex = Integer.parseInt(line);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            Bookmark bookmark = new Bookmark(url, lineIndex, description);
            if (mnemonic != null && mnemonic.length() == 1) {
                bookmark.setMnemonic(mnemonic.charAt(0));
            }
            result2.add(bookmark);
        }
        return result2;
    }

    private void writeExternal(Element element2) {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(this.myBookmarks.values());
        bookmarks.sort(Comparator.comparingInt(o -> o.index).reversed());
        for (Bookmark bookmark : bookmarks) {
            char mnemonic;
            int line;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.nullizeEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element2.addContent(bookmarkElement);
        }
    }

    public void moveBookmarkUp(@NotNull Bookmark bookmark) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index > 0) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index - 1);
            other.index = index;
            bookmark.index = index - 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    public void moveBookmarkDown(@NotNull Bookmark bookmark) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index < this.myBookmarks.values().size() - 1) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index + 1);
            other.index = index;
            bookmark.index = index + 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    @Nullable
    public Bookmark findLineBookmark(@NotNull Editor editor, boolean isWrapped, boolean next) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        ArrayList bookmarksForDocument = new ArrayList(this.myBookmarks.get((Object)file2));
        if (bookmarksForDocument.isEmpty()) {
            return null;
        }
        int sign = next ? 1 : -1;
        bookmarksForDocument.sort((o1, o2) -> sign * (o1.getLine() - o2.getLine()));
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (next && bookmark.getLine() > caretLine) {
                return bookmark;
            }
            if (next || bookmark.getLine() >= caretLine) continue;
            return bookmark;
        }
        return isWrapped && !bookmarksForDocument.isEmpty() ? (Bookmark)bookmarksForDocument.get(0) : null;
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark old = this.findBookmarkForMnemonic(c);
        if (old != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c);
        this.getPublisher().bookmarkChanged(bookmark);
    }

    public void setDescription(@NotNull Bookmark bookmark, @NotNull String description) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        bookmark.setDescription(description);
        this.getPublisher().bookmarkChanged(bookmark);
    }

    private void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks.values()) {
            bookmark.updateHighlighter();
        }
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Document doc = e.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.getLine() == -1) continue;
                    List list2 = BookmarkManager.this.myBeforeChangeData.computeIfAbsent(doc, __ -> new ArrayList());
                    list2.add(new Trinity((Object)bookmark, (Object)bookmark.getLine(), (Object)doc.getText(new TextRange(doc.getLineStartOffset(bookmark.getLine()), doc.getLineEndOffset(bookmark.getLine())))));
                }
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(e.getDocument());
            ArrayList<Bookmark> bookmarksToRemove = null;
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.isValid() && !this.isDuplicate(bookmark, file2, (List<Bookmark>)bookmarksToRemove)) continue;
                    if (bookmarksToRemove == null) {
                        bookmarksToRemove = new ArrayList<Bookmark>();
                    }
                    bookmarksToRemove.add(bookmark);
                }
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    this.moveToDeleted(bookmark);
                }
            }
            BookmarkManager.this.myBeforeChangeData.remove(e.getDocument());
            Iterator iterator2 = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                VirtualFile virtualFile = (VirtualFile)((Trinity)entry.getKey()).first;
                if (!virtualFile.isValid()) {
                    iterator2.remove();
                    continue;
                }
                Bookmark bookmark = (Bookmark)entry.getValue();
                Document document = bookmark.getCachedDocument();
                if (document == null || !bookmark.getFile().equals(virtualFile)) continue;
                Integer line = (Integer)((Trinity)entry.getKey()).second;
                if (document.getLineCount() <= line) continue;
                String bookmarkedText = (String)((Trinity)entry.getKey()).third;
                String lineContent = this.getLineContent(document, line);
                if (!bookmarkedText.equals(lineContent) && line > 1 && (bookmarkedText.equals(StringUtil.trimEnd((String)e.getNewFragment().toString(), (String)"\n")) || bookmarkedText.equals(StringUtil.trimEnd((String)e.getOldFragment().toString(), (String)"\n")))) {
                    line = line - 2;
                    lineContent = this.getLineContent(document, line);
                }
                if (!bookmarkedText.equals(lineContent) || BookmarkManager.this.findEditorBookmark(document, line) != null) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), line, bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator2.remove();
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @NotNull VirtualFile file2, @Nullable List<Bookmark> toRemove2) {
            for (Bookmark b : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove2 != null && toRemove2.contains(b)) continue;
                return true;
            }
            return false;
        }

        private void moveToDeleted(Bookmark bookmark) {
            List list2 = (List)BookmarkManager.this.myBeforeChangeData.get(bookmark.getCachedDocument());
            if (list2 != null) {
                for (Trinity trinity : list2) {
                    if (trinity.first != bookmark) continue;
                    BookmarkManager.this.removeBookmark(bookmark);
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(new Trinity((Object)bookmark.getFile(), trinity.second, trinity.third), bookmark);
                    break;
                }
            }
        }

        private String getLineContent(Document document, int line) {
            int start2 = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            return document.getText(new TextRange(start2, end));
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseListener {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & (SystemInfo.isMac ? 4 : 2)) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line = e.getLogicalPosition().line;
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }
    }

    static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        MyStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            project.getMessageBus().connect().subscribe(PsiDocumentListener.TOPIC, MyStartupActivity::documentCreated);
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(project);
            if (bookmarkManager.myBookmarks.isEmpty() && bookmarkManager.myPendingState.get() == null) {
                return;
            }
            ReadAction.nonBlocking(() -> {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (VirtualFile file2 : fileEditorManager.getOpenFiles()) {
                    Document document = fileDocumentManager.getDocument(file2);
                    if (document == null) continue;
                    MyStartupActivity.checkFile(document, file2, bookmarkManager, project);
                }
            }).expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance());
        }

        private static void documentCreated(@NotNull Document document, @Nullable PsiFile psiFile, @NotNull Project project) {
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(project);
            if (bookmarkManager.myBookmarks.isEmpty()) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (file2 == null) {
                return;
            }
            MyStartupActivity.checkFile(document, file2, bookmarkManager, project);
        }

        private static void checkFile(@NotNull Document document, @NotNull VirtualFile file2, @NotNull BookmarkManager bookmarkManager, @NotNull Project project) {
            Collection fileBookmarks = bookmarkManager.myBookmarks.get((Object)file2);
            if (fileBookmarks.isEmpty()) {
                return;
            }
            AppUIUtil.invokeLaterIfProjectAlive(project, () -> {
                MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
                for (Bookmark bookmark : fileBookmarks) {
                    bookmark.createHighlighter(markup);
                }
            });
        }
    }
}

