/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.items;

import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingItemBase
extends RunAnythingItem {
    @NotNull
    private final String myCommand;
    @Nullable
    protected final Icon myIcon;

    public RunAnythingItemBase(@NotNull String command, @Nullable Icon icon2) {
        this.myCommand = command;
        this.myIcon = icon2;
    }

    @Override
    @NotNull
    public String getCommand() {
        return this.myCommand;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public Component createComponent(@Nullable String pattern, boolean isSelected, boolean hasFocus) {
        Component oldComponent = this.createComponent(isSelected);
        if (oldComponent != null) {
            return oldComponent;
        }
        JPanel component2 = new JPanel(new BorderLayout());
        Color background = UIUtil.getListBackground((boolean)isSelected, (boolean)true);
        component2.setBackground(background);
        SimpleColoredComponent textComponent = new SimpleColoredComponent();
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)StringUtil.notNullize((String)this.getCommand()), (SimpleColoredComponent)textComponent, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)((NameUtil.MatcherBuilder)RunAnythingGroup.RUN_ANYTHING_MATCHER_BUILDER.fun((Object)pattern)).build(), (Color)background, (boolean)isSelected);
        component2.add((Component)textComponent, "West");
        textComponent.appendTextPadding(20);
        this.setupIcon(textComponent, this.myIcon);
        this.addDescription(component2, isSelected);
        return component2;
    }

    private void addDescription(@NotNull JPanel panel2, boolean isSelected) {
        String description = this.getDescription();
        if (description == null) {
            return;
        }
        SimpleColoredComponent descriptionComponent = new SimpleColoredComponent();
        descriptionComponent.append(description, RunAnythingItemBase.getDescriptionAttributes(isSelected));
        descriptionComponent.setTextAlign(4);
        panel2.add((Component)descriptionComponent, "Center");
    }

    public void setupIcon(@NotNull SimpleColoredComponent component2, @Nullable Icon icon2) {
        component2.setIcon((Icon)ObjectUtils.notNull((Object)icon2, (Object)EmptyIcon.ICON_16));
        component2.setIpad((Insets)JBUI.insets((int)0, (int)10, (int)0, (int)0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunAnythingItemBase base = (RunAnythingItemBase)o;
        return this.myCommand.equals(base.myCommand);
    }

    public int hashCode() {
        return this.myCommand.hashCode();
    }

    protected static void appendDescription(@NotNull SimpleColoredComponent component2, @Nullable String description, @NotNull Color foreground) {
        if (description != null) {
            SimpleTextAttributes smallAttributes = new SimpleTextAttributes(128, foreground);
            component2.append(StringUtil.shortenTextWithEllipsis((String)description, (int)40, (int)0), smallAttributes);
            component2.appendTextPadding(660, 4);
        }
    }

    @NotNull
    private static SimpleTextAttributes getDescriptionAttributes(boolean isSelected) {
        return new SimpleTextAttributes(0, isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor());
    }
}

