/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroupBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingCompletionGroup<V, P extends RunAnythingProvider<V>>
extends RunAnythingGroupBase {
    @NotNull
    private final P myProvider;

    public RunAnythingCompletionGroup(@NotNull P provider) {
        this.myProvider = provider;
    }

    @NotNull
    public P getProvider() {
        return this.myProvider;
    }

    @Override
    @NotNull
    public String getTitle() {
        return Objects.requireNonNull(this.getProvider().getCompletionGroupTitle());
    }

    @Override
    @NotNull
    public Collection<RunAnythingItem> getGroupItems(@NotNull DataContext dataContext, @NotNull String pattern) {
        Object provider = this.getProvider();
        return ContainerUtil.map(provider.getValues(dataContext, pattern), value2 -> provider.getMainListItem(dataContext, value2));
    }

    @Override
    @Nullable
    protected Matcher getMatcher(@NotNull DataContext dataContext, @NotNull String pattern) {
        return this.getProvider().getMatcher(dataContext, pattern);
    }

    public static Collection<RunAnythingGroup> createCompletionGroups() {
        return (Collection)((StreamEx)((StreamEx)StreamEx.of((Object[])RunAnythingProvider.EP_NAME.getExtensions()).map(provider -> RunAnythingCompletionGroup.createCompletionGroup(provider)).filter(Objects::nonNull)).distinct(group -> group.getTitle())).collect(Collectors.toList());
    }

    @Nullable
    public static RunAnythingGroup createCompletionGroup(@NotNull RunAnythingProvider provider) {
        String title = provider.getCompletionGroupTitle();
        if (title == null) {
            return null;
        }
        if (RunAnythingGeneralGroup.getGroupTitle().equals(title)) {
            return new RunAnythingGeneralGroup();
        }
        return new RunAnythingCompletionGroup(provider);
    }
}

