/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.runAnything.RunAnythingPopupUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingManager {
    private static final String LOCATION_SETTINGS_KEY = "run.anything.popup";
    private final Project myProject;
    private JBPopup myBalloon;
    private RunAnythingPopupUI myRunAnythingUI;
    private Dimension myBalloonFullSize;
    @Nullable
    private String mySelectedText;

    public RunAnythingManager(@NotNull Project project) {
        this.myProject = project;
    }

    public static RunAnythingManager getInstance(@NotNull Project project) {
        return (RunAnythingManager)ServiceManager.getService((Project)project, RunAnythingManager.class);
    }

    public void show(@Nullable String searchText, @NotNull AnActionEvent initEvent) {
        this.show(searchText, true, initEvent);
    }

    public void show(@Nullable String searchText, boolean selectSearchText, @NotNull AnActionEvent initEvent) {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        Project project = initEvent.getProject();
        this.myRunAnythingUI = this.createView(initEvent);
        if (searchText != null && !searchText.isEmpty()) {
            this.myRunAnythingUI.getSearchField().setText(searchText);
        }
        this.predefineSelectedText(searchText);
        if (selectSearchText) {
            this.myRunAnythingUI.getSearchField().selectAll();
        }
        this.myBalloon = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this.myRunAnythingUI), (JComponent)this.myRunAnythingUI.getSearchField()).setProject(this.myProject).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).setCancelCallback(() -> {
            if (this.isShown() && !Objects.equals(this.myRunAnythingUI.getUserInputText(), searchText)) {
                this.saveSearchText();
            }
            return true;
        }).addUserData((Object)"SIMPLE_WINDOW").setResizable(true).setMovable(true).setDimensionServiceKey(this.myProject, LOCATION_SETTINGS_KEY, true).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)this.myBalloon, (Disposable)this.myRunAnythingUI);
        if (project != null) {
            Disposer.register((Disposable)project, (Disposable)this.myBalloon);
        }
        Dimension size = this.myRunAnythingUI.getMinimumSize();
        JBInsets.addTo((Dimension)size, (Insets)this.myBalloon.getContent().getInsets());
        this.myBalloon.setMinimumSize(size);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.saveSize();
            this.myRunAnythingUI = null;
            this.myBalloon = null;
            this.myBalloonFullSize = null;
        });
        if (this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            this.myBalloonFullSize = WindowStateService.getInstance((Project)this.myProject).getSize(LOCATION_SETTINGS_KEY);
            Dimension prefSize = this.myRunAnythingUI.getPreferredSize();
            this.myBalloon.setSize(prefSize);
        }
        this.calcPositionAndShow(project, this.myBalloon);
    }

    private void predefineSelectedText(@Nullable String searchText) {
        if (StringUtil.isEmpty((String)searchText)) {
            searchText = this.mySelectedText;
        }
        if (StringUtil.isNotEmpty((String)searchText)) {
            this.myRunAnythingUI.getSearchField().setText(searchText);
        }
    }

    private void saveSearchText() {
        this.mySelectedText = this.myRunAnythingUI.getUserInputText();
    }

    private void calcPositionAndShow(Project project, JBPopup balloon) {
        Point savedLocation = WindowStateService.getInstance((Project)this.myProject).getLocation(LOCATION_SETTINGS_KEY);
        if (project != null) {
            balloon.showCenteredInCurrentWindow(project);
        } else {
            balloon.showInFocusCenter();
        }
        if (savedLocation == null && this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            Point location = balloon.getLocationOnScreen();
            location.y /= 2;
            balloon.setLocation(location);
        }
    }

    public boolean isShown() {
        return this.myRunAnythingUI != null && this.myBalloon != null && !this.myBalloon.isDisposed();
    }

    @NotNull
    private RunAnythingPopupUI createView(@NotNull AnActionEvent event) {
        RunAnythingPopupUI view = new RunAnythingPopupUI(event);
        view.setSearchFinishedHandler(() -> {
            if (this.isShown()) {
                this.myBalloon.cancel();
            }
        });
        view.addViewTypeListener(viewType -> {
            if (!this.isShown()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Dimension minSize = view.getMinimumSize();
                JBInsets.addTo((Dimension)minSize, (Insets)this.myBalloon.getContent().getInsets());
                this.myBalloon.setMinimumSize(minSize);
                if (viewType == BigPopupUI.ViewType.SHORT) {
                    this.myBalloonFullSize = this.myBalloon.getSize();
                    JBInsets.removeFrom((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    this.myBalloon.pack(false, true);
                } else {
                    if (this.myBalloonFullSize == null) {
                        this.myBalloonFullSize = view.getPreferredSize();
                        JBInsets.addTo((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    }
                    this.myBalloonFullSize.height = Integer.max(this.myBalloonFullSize.height, minSize.height);
                    this.myBalloonFullSize.width = Integer.max(this.myBalloonFullSize.width, minSize.width);
                    this.myBalloon.setSize(this.myBalloonFullSize);
                }
            });
        });
        return view;
    }

    private void saveSize() {
        if (this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            WindowStateService.getInstance((Project)this.myProject).putSize(LOCATION_SETTINGS_KEY, this.myBalloonFullSize);
        }
    }
}

