/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.Executor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.runAnything.RunAnythingManager;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandExecutionProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.FontUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingAction
extends AnAction
implements CustomComponentAction,
DumbAware {
    public static final String RUN_ANYTHING_ACTION_ID = "RunAnything";
    public static final DataKey<Executor> EXECUTOR_KEY = DataKey.create((String)"EXECUTOR_KEY");
    public static final AtomicBoolean SHIFT_IS_PRESSED = new AtomicBoolean(false);
    public static final AtomicBoolean ALT_IS_PRESSED = new AtomicBoolean(false);
    private boolean myIsDoubleCtrlRegistered;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (Registry.is((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 17) {
            return;
        }
        Project project = e.getProject();
        if (project != null && !LightEdit.owns((Project)project)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(RUN_ANYTHING_ACTION_ID);
            RunAnythingManager runAnythingManager = RunAnythingManager.getInstance(project);
            String text = GotoActionBase.getInitialTextForNavigation(e);
            runAnythingManager.show(text, e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (KeymapUtil.getActiveKeymapShortcuts((String)RUN_ANYTHING_ACTION_ID).getShortcuts().length == 0) {
            if (!this.myIsDoubleCtrlRegistered) {
                ModifierKeyDoubleClickHandler.getInstance().registerAction(RUN_ANYTHING_ACTION_ID, 17, -1, false);
                this.myIsDoubleCtrlRegistered = true;
            }
        } else if (this.myIsDoubleCtrlRegistered) {
            ModifierKeyDoubleClickHandler.getInstance().unregisterAction(RUN_ANYTHING_ACTION_ID);
            this.myIsDoubleCtrlRegistered = false;
        }
        boolean isEnabled = Holder.IS_ACTION_ENABLED;
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        return new ActionButton(this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            protected void updateToolTipText() {
                HelpTooltip.dispose((Component)this);
                new HelpTooltip().setTitle(this.myPresentation.getText()).setShortcut(this.getShortcut()).setDescription(IdeBundle.message((String)"run.anything.action.tooltip.text", (Object[])new Object[0])).installOn((JComponent)this);
            }

            @Nullable
            private String getShortcut() {
                if (RunAnythingAction.this.myIsDoubleCtrlRegistered) {
                    return IdeBundle.message((String)"double.ctrl.or.shift.shortcut", (Object[])new Object[]{SystemInfo.isMac ? FontUtil.thinSpace() + "\u2303" : "Ctrl"});
                }
                return null;
            }

            @Override
            public void setToolTipText(String s) {
                String shortcutText = this.getShortcutText();
                super.setToolTipText(StringUtil.isNotEmpty((String)shortcutText) ? s + " (" + shortcutText + ")" : s);
            }
        };
    }

    static {
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            if (event instanceof KeyEvent) {
                int keyCode = ((KeyEvent)event).getKeyCode();
                if (keyCode == 16) {
                    SHIFT_IS_PRESSED.set(event.getID() == 401);
                } else if (keyCode == 18) {
                    ALT_IS_PRESSED.set(event.getID() == 401);
                }
            }
            return false;
        }, null);
    }

    private static class Holder {
        private static final boolean IS_ACTION_ENABLED = Arrays.stream(RunAnythingProvider.EP_NAME.getExtensions()).anyMatch(provider -> !(provider instanceof RunAnythingRunConfigurationProvider) && !(provider instanceof RunAnythingRecentProjectProvider) && !(provider instanceof RunAnythingRecentCommandProvider) && !(provider instanceof RunAnythingCommandExecutionProvider));

        private Holder() {
        }
    }
}

