/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UndoRedoAction
extends DumbAwareAction
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(UndoRedoAction.class);
    public static final Key<Boolean> IGNORE_SWING_UNDO_MANAGER = new Key("IGNORE_SWING_UNDO_MANAGER");
    private boolean myActionInProgress;

    public UndoRedoAction() {
        this.setEnabledInModalContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = this.getUndoManager(editor, dataContext);
        this.myActionInProgress = true;
        try {
            this.perform(editor, undoManager);
        }
        finally {
            this.myActionInProgress = false;
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = this.getUndoManager(editor, dataContext);
        if (undoManager == null) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setEnabled(this.isAvailable(editor, undoManager));
        Pair<String, String> pair = this.getActionNameAndDescription(editor, undoManager);
        presentation2.setText((String)pair.first);
        presentation2.setDescription((String)pair.second);
    }

    private UndoManager getUndoManager(FileEditor editor, DataContext dataContext) {
        Component component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (component2 instanceof JTextComponent && !UIUtil.isClientPropertyTrue((Object)component2, IGNORE_SWING_UNDO_MANAGER)) {
            return SwingUndoManagerWrapper.fromContext(dataContext);
        }
        JRootPane rootPane = null;
        JBPopup popup2 = null;
        if (editor == null) {
            rootPane = UIUtil.getRootPane((Component)component2);
            popup2 = rootPane != null ? (JBPopup)rootPane.getClientProperty("JBPopup") : null;
            boolean modalPopup = popup2 != null && popup2.isModalContext();
            boolean modalContext = Boolean.TRUE.equals(PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext));
            if (modalPopup || modalContext) {
                return SwingUndoManagerWrapper.fromContext(dataContext);
            }
        }
        if (this.myActionInProgress) {
            LOG.error("Recursive undo invocation attempt, component: " + component2 + ", fileEditor: " + editor + ", rootPane: " + rootPane + ", popup: " + popup2);
            return null;
        }
        Project project = UndoRedoAction.getProject(editor, dataContext);
        return project != null && !project.isDefault() ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
    }

    private static Project getProject(FileEditor editor, DataContext dataContext) {
        Project project = editor instanceof TextEditor ? ((TextEditor)editor).getEditor().getProject() : (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project;
    }

    protected abstract void perform(FileEditor var1, UndoManager var2);

    protected abstract boolean isAvailable(FileEditor var1, UndoManager var2);

    protected abstract Pair<String, String> getActionNameAndDescription(FileEditor var1, UndoManager var2);

    private static class SwingUndoManagerWrapper
    extends UndoManager {
        private final javax.swing.undo.UndoManager mySwingUndoManager;

        @Nullable
        static UndoManager fromContext(DataContext dataContext) {
            javax.swing.undo.UndoManager swingUndoManager = UIUtil.getUndoManager((Component)((Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)));
            return swingUndoManager != null ? new SwingUndoManagerWrapper(swingUndoManager) : null;
        }

        SwingUndoManagerWrapper(javax.swing.undo.UndoManager swingUndoManager) {
            this.mySwingUndoManager = swingUndoManager;
        }

        public void undoableActionPerformed(@NotNull UndoableAction action2) {
        }

        public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        }

        public boolean isUndoInProgress() {
            return false;
        }

        public boolean isRedoInProgress() {
            return false;
        }

        public void undo(@Nullable FileEditor editor) {
            this.mySwingUndoManager.undo();
        }

        public void redo(@Nullable FileEditor editor) {
            this.mySwingUndoManager.redo();
        }

        public boolean isUndoAvailable(@Nullable FileEditor editor) {
            return this.mySwingUndoManager.canUndo();
        }

        public boolean isRedoAvailable(@Nullable FileEditor editor) {
            return this.mySwingUndoManager.canRedo();
        }

        @NotNull
        public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor) {
            return SwingUndoManagerWrapper.getUndoOrRedoActionNameAndDescription(true);
        }

        @NotNull
        public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor) {
            return SwingUndoManagerWrapper.getUndoOrRedoActionNameAndDescription(false);
        }

        @NotNull
        private static Pair<String, String> getUndoOrRedoActionNameAndDescription(boolean undo) {
            String command = undo ? "undo" : "redo";
            return Pair.create((Object)ActionsBundle.message((String)("action." + command + ".text"), (Object[])new Object[]{""}).trim(), (Object)ActionsBundle.message((String)("action." + command + ".description"), (Object[])new Object[]{ActionsBundle.message((String)("action." + command + ".description.empty"), (Object[])new Object[0])}).trim());
        }
    }
}

