/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsGroup
extends ActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ToolWindowsGroup.getEventProject((AnActionEvent)e) != null);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project = ToolWindowsGroup.getEventProject((AnActionEvent)e);
        if (project == null) {
            return EMPTY_ARRAY;
        }
        List<ActivateToolWindowAction> result2 = ToolWindowsGroup.getToolWindowActions(project, false);
        return result2.toArray(AnAction.EMPTY_ARRAY);
    }

    public static List<ActivateToolWindowAction> getToolWindowActions(@NotNull Project project, boolean shouldSkipHidden) {
        ActionManager actionManager = ActionManager.getInstance();
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ArrayList<ActivateToolWindowAction> result2 = new ArrayList<ActivateToolWindowAction>();
        for (String id2 : manager.getToolWindowIds()) {
            String actionId;
            AnAction action2;
            if (shouldSkipHidden && !manager.getToolWindow(id2).isShowStripeButton() || !((action2 = actionManager.getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(id2))) instanceof ActivateToolWindowAction)) continue;
            result2.add((ActivateToolWindowAction)action2);
        }
        result2.sort(ToolWindowsGroup.getActionComparator());
        return result2;
    }

    @NotNull
    private static Comparator<ActivateToolWindowAction> getActionComparator() {
        return ToolWindowsGroup.comparingMnemonic().thenComparing(it -> it.getToolWindowId(), String.CASE_INSENSITIVE_ORDER);
    }

    @NotNull
    private static Comparator<ActivateToolWindowAction> comparingMnemonic() {
        return Comparator.comparingInt(it -> {
            int mnemonic = ActivateToolWindowAction.getMnemonicForToolWindow(it.getToolWindowId());
            return mnemonic != -1 ? mnemonic : Integer.MAX_VALUE;
        });
    }
}

