/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ToggleFullScreenAction
extends DumbAwareAction
implements LightEditCompatible {
    ToggleFullScreenAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeFrameEx frame = ToggleFullScreenAction.getFrameHelper(e.getProject());
        if (frame != null) {
            frame.toggleFullScreen(!frame.isInFullScreen());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation p = e.getPresentation();
        IdeFrameEx frame = null;
        boolean isApplicable = WindowManager.getInstance().isFullScreenSupportedInCurrentOS();
        if (isApplicable) {
            frame = ToggleFullScreenAction.getFrameHelper(e.getProject());
            boolean bl = isApplicable = frame != null;
        }
        if (e.getPlace() != "MainToolbar") {
            p.setVisible(isApplicable);
        }
        p.setEnabled(isApplicable);
        if (isApplicable) {
            p.setText(frame.isInFullScreen() ? Holder.getTextExitFullScreen() : Holder.getTextEnterFullScreen());
        }
    }

    @Nullable
    private static IdeFrameEx getFrameHelper(@Nullable Project project) {
        return WindowManagerEx.getInstanceEx().findFrameHelper(project);
    }

    private static class Holder {
        private Holder() {
        }

        private static String getTextEnterFullScreen() {
            return ActionsBundle.message((String)"action.ToggleFullScreen.text.enter", (Object[])new Object[0]);
        }

        private static String getTextExitFullScreen() {
            return ActionsBundle.message((String)"action.ToggleFullScreen.text.exit", (Object[])new Object[0]);
        }
    }
}

