/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class TechnicalSupportAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(ApplicationInfoImpl.getShadowInstance().getSupportUrl() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String urlTemplate = appInfo.getSupportUrl();
        String url = urlTemplate.replace("$BUILD", appInfo.getBuild().asStringWithoutProductCode()).replace("$OS", TechnicalSupportAction.getOSName()).replace("$TIMEZONE", System.getProperty("user.timezone"));
        BrowserUtil.browse((String)StringUtil.replace((String)url, (String)" ", (String)"%20"), (Project)e.getProject());
    }

    private static String getOSName() {
        String name = "";
        if (SystemInfo.isWindows) {
            name = name + "win-";
            name = name + TechnicalSupportAction.getWindowsVersion();
            if (SystemInfo.is64Bit) {
                name = name + "-64";
            }
        } else if (SystemInfo.isLinux) {
            name = name + "linux";
        } else if (SystemInfo.isSolaris) {
            name = name + "solaris";
        } else if (SystemInfo.isMac) {
            name = name + "mac";
            if (!SystemInfo.isOsVersionAtLeast((String)"10.8")) {
                name = name + "-old";
            }
        } else {
            name = name + "other-os";
        }
        return name;
    }

    private static boolean isWindowsVersion(String version2) {
        return StringUtil.compareVersionNumbers((String)SystemInfo.OS_VERSION, (String)version2) == 0;
    }

    private static String getWindowsVersion() {
        if (TechnicalSupportAction.isWindowsVersion("5.1")) {
            return "xp";
        }
        if (TechnicalSupportAction.isWindowsVersion("5.2")) {
            return "2003";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.0")) {
            return "vista";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.1")) {
            return "7";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.2")) {
            return "8";
        }
        if (TechnicalSupportAction.isWindowsVersion("10.0")) {
            return "10";
        }
        return "";
    }
}

