/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowFilePathAction
extends DumbAwareAction {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final NotificationListener FILE_SELECTING_LISTENER = RevealFileAction.FILE_SELECTING_LISTENER;

    public void update(@NotNull AnActionEvent e) {
        boolean visible = !SystemInfo.isMac && RevealFileAction.isSupported();
        e.getPresentation().setVisible(visible);
        if (visible) {
            VirtualFile file2 = ShowFilePathAction.getFile(e);
            e.getPresentation().setEnabled(file2 != null);
            e.getPresentation().setText(ActionsBundle.messagePointer((String)(file2 != null && file2.isDirectory() ? "action.ShowFilePath.directory" : "action.ShowFilePath.file"), (Object[])new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2 = ShowFilePathAction.getFile(e);
        if (file2 != null) {
            ShowFilePathAction.show(file2, (Consumer<? super ListPopup>)((Consumer)popup2 -> {
                DataManager dataManager = DataManager.getInstance();
                if (dataManager != null) {
                    dataManager.getDataContextFromFocusAsync().onSuccess(arg_0 -> ((ListPopup)popup2).showInBestPositionFor(arg_0));
                }
            }));
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files2 == null || files2.length == 1 ? (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE) : null;
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        ShowFilePathAction.show(file2, (Consumer<? super ListPopup>)((Consumer)popup2 -> {
            if (e.getComponent().isShowing()) {
                popup2.show(new RelativePoint(e));
            }
        }));
    }

    private static void show(@NotNull VirtualFile file2, @NotNull Consumer<? super ListPopup> action2) {
        if (!RevealFileAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files2.size();
            files2.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (String url : fileUrls) {
                File ioFile = new File(url);
                icons.add(ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16);
            }
            ApplicationManager.getApplication().invokeLater(() -> action2.consume((Object)ShowFilePathAction.createPopup(files2, icons)));
        });
    }

    private static String getPresentableUrl(VirtualFile file2) {
        String url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<? extends VirtualFile> files2, List<? extends Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files2, icons){

            @NotNull
            public String getTextFor(VirtualFile value2) {
                return value2.getPresentableName();
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RevealFileAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean isSupported() {
        return RevealFileAction.isSupported();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String getFileManagerName() {
        return RevealFileAction.getFileManagerName();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openFile(@NotNull File file2) {
        RevealFileAction.openFile(file2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openDirectory(@NotNull File directory) {
        RevealFileAction.openDirectory(directory);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void showDialog(Project project, String message, String title, @NotNull File file2, @Nullable DialogWrapper.DoNotAskOption option2) {
        RevealFileAction.showDialog(project, message, title, file2, option2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        return RevealFileAction.findLocalFile(file2);
    }
}

