/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentProjectsGroup
extends ActionGroup
implements DumbAware {
    public RecentProjectsGroup() {
        Presentation presentation2 = this.getTemplatePresentation();
        presentation2.setText(ActionsBundle.messagePointer((String)(SystemInfo.isMac ? "group.reopen.mac.text" : "group.reopen.win.text"), (Object[])new Object[0]));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return RecentProjectsGroup.removeCurrentProject(e == null ? null : e.getProject(), RecentProjectListActionProvider.getInstance().getActions(true));
    }

    public static AnAction[] removeCurrentProject(Project project, @NotNull List<AnAction> actions) {
        if (project == null) {
            return actions.toArray(EMPTY_ARRAY);
        }
        RecentProjectListActionProvider provider = RecentProjectListActionProvider.getInstance();
        ArrayList<AnAction> list2 = new ArrayList<AnAction>();
        for (AnAction action2 : actions) {
            if (action2 instanceof ReopenProjectAction && provider.isCurrentProjectAction(project, (ReopenProjectAction)action2)) continue;
            list2.add(action2);
        }
        return list2.toArray(EMPTY_ARRAY);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        presentation2.setEnabled(RecentProjectListActionProvider.getInstance().getActions(true).size() > 0);
    }
}

