/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenModuleSettingsAction
extends EditSourceAction {
    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        if (!OpenModuleSettingsAction.isModuleInProjectViewPopup(event)) {
            event.getPresentation().setEnabledAndVisible(false);
        }
    }

    protected static boolean isModuleInProjectViewPopup(@NotNull AnActionEvent e) {
        if ("ProjectViewPopup".equals(e.getPlace())) {
            return OpenModuleSettingsAction.isModuleInContext(e);
        }
        return false;
    }

    public static boolean isModuleInContext(@NotNull AnActionEvent e) {
        Project project = OpenModuleSettingsAction.getEventProject((AnActionEvent)e);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (project != null && module != null) {
            VirtualFile moduleFolder = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (moduleFolder == null) {
                return false;
            }
            if (ProjectRootsUtil.isModuleContentRoot(moduleFolder, project) || ProjectRootsUtil.isModuleSourceRoot(moduleFolder, project)) {
                return true;
            }
        }
        return false;
    }
}

