/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public final class JumpToLastWindowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        String id2 = manager.getLastActiveToolWindowId();
        if (id2 == null || !manager.getToolWindow(id2).isAvailable()) {
            return;
        }
        manager.getToolWindow(id2).activate(null);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        String id2 = manager.getLastActiveToolWindowId();
        presentation2.setEnabled(id2 != null && manager.getToolWindow(id2).isAvailable());
    }
}

