/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyPathsAction
extends AnAction
implements DumbAware {
    public CopyPathsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && files2.length > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyPathsAction.getPaths(files2)));
        }
    }

    private static String getPaths(VirtualFile[] files2) {
        StringBuilder buf = new StringBuilder(files2.length * 64);
        for (VirtualFile file2 : files2) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(file2.getPresentableUrl());
        }
        return buf.toString();
    }

    public void update(@NotNull AnActionEvent event) {
        if (CopyPathsAction.isCopyReferencePopupAvailable()) {
            event.getPresentation().setEnabledAndVisible("keyboard shortcut".equals(event.getPlace()));
            return;
        }
        VirtualFile[] files2 = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        int num = files2 != null ? files2.length : 0;
        Presentation presentation2 = event.getPresentation();
        presentation2.setEnabled(num > 0);
        presentation2.setVisible(num > 0 || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation2.setText(IdeBundle.messagePointer((String)(num == 1 ? "action.copy.path" : "action.copy.paths"), (Object[])new Object[0]));
    }

    public static boolean isCopyReferencePopupAvailable() {
        return !ApplicationManager.getApplication().isUnitTestMode() && Experiments.getInstance().isFeatureEnabled("copy.reference.popup");
    }
}

