/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.copy.CopyHandler;
import org.jetbrains.annotations.NotNull;

public class CopyElementAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] elements2;
        PsiDirectory defaultTargetDirectory;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments(), "", null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement targetPsiElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        PsiDirectory psiDirectory = defaultTargetDirectory = targetPsiElement instanceof PsiDirectory ? (PsiDirectory)targetPsiElement : null;
        if (editor != null) {
            PsiElement aElement = CopyElementAction.getTargetElement(editor, project);
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            elements2 = new PsiElement[]{aElement};
            if (aElement == null || !CopyHandler.canCopy(elements2)) {
                elements2 = new PsiElement[]{file2};
            }
        } else {
            elements2 = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        }
        this.doCopy(elements2, defaultTargetDirectory);
    }

    protected void doCopy(PsiElement[] elements2, PsiDirectory defaultTargetDirectory) {
        CopyHandler.doCopy(elements2, defaultTargetDirectory);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation2.setEnabled(false);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            this.updateForEditor(dataContext, presentation2);
        } else {
            this.updateForToolWindow(dataContext, presentation2);
        }
    }

    protected void updateForEditor(DataContext dataContext, Presentation presentation2) {
        boolean result2;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation2.setVisible(false);
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        PsiElement element2 = CopyElementAction.getTargetElement(editor, project);
        Ref actionName = new Ref();
        boolean bl = result2 = element2 != null && CopyHandler.canCopy(new PsiElement[]{element2}, (Ref<String>)actionName);
        if (!result2 && file2 != null) {
            result2 = CopyHandler.canCopy(new PsiElement[]{file2}, (Ref<String>)actionName);
        }
        presentation2.setEnabled(result2);
        presentation2.setVisible(true);
        if (!actionName.isNull()) {
            presentation2.setText((String)actionName.get());
        }
    }

    protected void updateForToolWindow(DataContext dataContext, Presentation presentation2) {
        PsiElement[] elements2 = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        Ref actionName = new Ref();
        presentation2.setEnabled(elements2 != null && CopyHandler.canCopy(elements2, (Ref<String>)actionName));
        if (!actionName.isNull()) {
            presentation2.setText((String)actionName.get());
        }
    }

    private static PsiElement getTargetElement(Editor editor, Project project) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            element2 = file2;
        }
        return element2;
    }
}

