/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.CommandLineWaitingManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.CommandLineArgs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance(CommandLineProcessor.class);
    private static final String OPTION_WAIT = "--wait";
    public static final Future<CliResult> OK_FUTURE = CompletableFuture.completedFuture(CliResult.OK);

    private CommandLineProcessor() {
    }

    @ApiStatus.Internal
    @NotNull
    public static CommandLineProcessorResult doOpenFileOrProject(@NotNull Path file2, boolean shouldWait) {
        OpenProjectTask openProjectOptions = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, null);
        openProjectOptions.checkDirectoryForFileBasedProjects = false;
        Project project = ProjectUtil.openOrImport(file2, openProjectOptions);
        if (project == null) {
            return CommandLineProcessor.doOpenFile(file2, -1, -1, false, shouldWait);
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForProject(project) : OK_FUTURE);
    }

    @NotNull
    private static CommandLineProcessorResult doOpenFile(@NotNull Path ioFile, int line, int column, boolean tempProject, boolean shouldWait) {
        RecentProjectsManager recentProjectManager;
        Project[] projects;
        Project[] projectArray = projects = tempProject ? new Project[]{} : ProjectUtil.getOpenProjects();
        if (!tempProject && projects.length == 0 && PlatformUtils.isDataGrip() && (recentProjectManager = RecentProjectsManager.getInstance()).willReopenProjectOnStart() && recentProjectManager.reopenLastProjectsOnStart()) {
            projects = ProjectUtil.getOpenProjects();
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)ioFile.toString()));
        assert (file2 != null);
        if (projects.length == 0) {
            Project project = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(ioFile, line, column, tempProject);
            if (project == null) {
                return CommandLineProcessorResult.createError("No project found to open file in");
            }
            return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        Project project = CommandLineProcessor.findBestProject(file2, projects);
        if (LightEdit.owns((Project)project)) {
            if (LightEdit.openFile((VirtualFile)file2)) {
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            }
        } else {
            OpenFileDescriptor navigatable = line > 0 ? new OpenFileDescriptor(project, file2, line - 1, Math.max(column, 0)) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).execute(() -> CommandLineProcessor.lambda$doOpenFile$0((Navigatable)navigatable));
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
    }

    @NotNull
    private static Project findBestProject(@NotNull VirtualFile file2, @NotNull @NotNull Project @NotNull [] projects) {
        Project project;
        for (Project project2 : projects) {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project2);
            if (!((Boolean)ReadAction.compute(() -> fileIndex.isInContent(file2))).booleanValue()) continue;
            return project2;
        }
        if (LightEditService.getInstance().canOpen(file2) && !LightEditUtil.isOpenInExistingProject()) {
            return LightEditUtil.getProject();
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project = frame.getProject()) != null && !LightEdit.owns((Project)project)) {
            return project;
        }
        return projects[0];
    }

    @NotNull
    public static CommandLineProcessorResult processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("External command line:").append('\n');
        logMessage.append("Dir: ").append(currentDirectory).append('\n');
        for (String arg : args) {
            logMessage.append(arg).append('\n');
        }
        logMessage.append("-----");
        LOG.info(logMessage.toString());
        if (args.isEmpty()) {
            return new CommandLineProcessorResult(null, OK_FUTURE);
        }
        String command = args.get(0);
        CommandLineProcessorResult result2 = (CommandLineProcessorResult)ApplicationStarter.EP_NAME.computeSafeIfAny(starter2 -> {
            if (!command.equals(starter2.getCommandName())) {
                return null;
            }
            if (starter2.canProcessExternalCommandLine()) {
                LOG.info("Processing command with " + starter2);
                return new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory));
            }
            return CommandLineProcessorResult.createError("Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.");
        });
        if (result2 != null) {
            return result2;
        }
        if (command.startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)command);
            ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            return new CommandLineProcessorResult(null, OK_FUTURE);
        }
        CommandLineProcessorResult projectAndCallback = null;
        int line = -1;
        int column = -1;
        boolean tempProject = false;
        boolean shouldWait = args.contains(OPTION_WAIT);
        LightEditUtil.setForceOpenInExistingProject(false);
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String arg = args.get(i2);
            if (CommandLineArgs.isKnownArgument(arg) || OPTION_WAIT.equals(arg)) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i2 == args.size()) break;
                line = StringUtil.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("-c") || arg.equals("--column")) {
                if (++i2 == args.size()) break;
                column = StringUtil.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (arg.equals("-p") || arg.equals("--project")) {
                LightEditUtil.setForceOpenInExistingProject(true);
                continue;
            }
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.unquoteString((String)arg);
            }
            Path file2 = null;
            try {
                file2 = Paths.get(arg, new String[0]);
                if (!file2.isAbsolute()) {
                    file2 = currentDirectory == null ? file2.toAbsolutePath() : Paths.get(currentDirectory, new String[0]).resolve(file2);
                }
                file2 = file2.normalize();
            }
            catch (InvalidPathException e) {
                LOG.warn((Throwable)e);
            }
            if (file2 == null || !Files.exists(file2, new LinkOption[0])) {
                return CommandLineProcessorResult.createError("Cannot find file '" + arg + "'");
            }
            projectAndCallback = line != -1 || tempProject ? CommandLineProcessor.doOpenFile(file2, line, column, tempProject, shouldWait) : CommandLineProcessor.doOpenFileOrProject(file2, shouldWait);
            if (shouldWait) break;
            column = -1;
            line = -1;
            tempProject = false;
        }
        if (shouldWait && projectAndCallback == null) {
            return new CommandLineProcessorResult(null, CliResult.error((int)1, (String)"--wait must be supplied with file or project to wait for"));
        }
        return projectAndCallback == null ? new CommandLineProcessorResult(null, OK_FUTURE) : projectAndCallback;
    }

    private static /* synthetic */ void lambda$doOpenFile$0(Navigatable navigatable) {
        navigatable.navigate(true);
    }
}

