/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInModuleElement;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="facet-type")
public class DisabledAutodetectionByTypeElement {
    public static final Comparator<DisabledAutodetectionByTypeElement> COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getFacetTypeId(), (String)o2.getFacetTypeId(), (boolean)true);
    private String myFacetTypeId;
    private List<DisabledAutodetectionInModuleElement> myModuleElements = new SortedList(DisabledAutodetectionInModuleElement.COMPARATOR);

    public DisabledAutodetectionByTypeElement() {
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName, String url, boolean recursively) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, url, recursively));
    }

    @Attribute(value="id")
    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    @XCollection(propertyElementName="modules")
    public List<DisabledAutodetectionInModuleElement> getModuleElements() {
        return this.myModuleElements;
    }

    public void setFacetTypeId(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public void setModuleElements(List<DisabledAutodetectionInModuleElement> moduleElements) {
        this.myModuleElements = moduleElements;
    }

    public void addDisabled(@NotNull String moduleName) {
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element2 = this.findElement(moduleName);
        if (element2 != null) {
            element2.getFiles().clear();
            element2.getDirectories().clear();
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public void disableInProject() {
        this.myModuleElements.clear();
    }

    public void addDisabled(@NotNull String moduleName, @NotNull String fileUrl, boolean recursively) {
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element2 = this.findElement(moduleName);
        if (element2 != null) {
            if (!element2.isDisableInWholeModule()) {
                if (recursively) {
                    element2.getDirectories().add(fileUrl);
                } else {
                    element2.getFiles().add(fileUrl);
                }
            }
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, fileUrl, recursively));
    }

    @Nullable
    public DisabledAutodetectionInModuleElement findElement(@NotNull String moduleName) {
        for (DisabledAutodetectionInModuleElement element2 : this.myModuleElements) {
            if (!moduleName.equals(element2.getModuleName())) continue;
            return element2;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisabledAutodetectionByTypeElement that = (DisabledAutodetectionByTypeElement)o;
        return this.myFacetTypeId.equals(that.myFacetTypeId) && this.myModuleElements.equals(that.myModuleElements);
    }

    public int hashCode() {
        return this.myFacetTypeId.hashCode() + 31 * this.myModuleElements.hashCode();
    }

    public boolean isDisabled(String moduleName, String url) {
        if (this.myModuleElements.isEmpty()) {
            return true;
        }
        DisabledAutodetectionInModuleElement element2 = this.findElement(moduleName);
        if (element2 == null) {
            return false;
        }
        if (element2.isDisableInWholeModule() || element2.getFiles().contains(url)) {
            return true;
        }
        for (String directoryUrl : element2.getDirectories()) {
            if (!directoryUrl.endsWith("/")) {
                directoryUrl = directoryUrl + "/";
            }
            if (!url.startsWith(directoryUrl) && (SystemInfo.isFileSystemCaseSensitive || !StringUtil.startsWithIgnoreCase((String)url, (String)directoryUrl))) continue;
            return true;
        }
        return false;
    }

    public boolean removeDisabled(String moduleName) {
        Iterator<DisabledAutodetectionInModuleElement> iterator2 = this.myModuleElements.iterator();
        while (iterator2.hasNext()) {
            DisabledAutodetectionInModuleElement element2 = iterator2.next();
            if (!element2.getModuleName().equals(moduleName)) continue;
            iterator2.remove();
            break;
        }
        return this.myModuleElements.size() > 0;
    }
}

