/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateLanguageFormattingModelBuilder
implements DelegatingFormattingModelBuilder,
TemplateLanguageBlockFactory {
    @NotNull
    public FormattingModel createModel(PsiElement element2, CodeStyleSettings settings) {
        PsiFile file2 = element2.getContainingFile();
        Block rootBlock = this.getRootBlock((PsiElement)file2, file2.getViewProvider(), settings);
        return new DocumentBasedFormattingModel(rootBlock, element2.getProject(), settings, file2.getFileType(), file2);
    }

    protected Block getRootBlock(PsiElement element2, FileViewProvider viewProvider, CodeStyleSettings settings) {
        ASTNode node = element2.getNode();
        if (node == null) {
            return this.createDummyBlock(node);
        }
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            Language dataLanguage = ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
            FormattingModelBuilder builder2 = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(dataLanguage);
            if (builder2 instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)builder2).dontFormatMyModel(element2)) {
                return this.createDummyBlock(node);
            }
            if (builder2 != null) {
                FormattingModel model = builder2.createModel((PsiElement)viewProvider.getPsi(dataLanguage), settings);
                List<DataLanguageBlockWrapper> childWrappers = BlockUtil.buildChildWrappers(model.getRootBlock());
                if (childWrappers.size() == 1) {
                    childWrappers = BlockUtil.buildChildWrappers(childWrappers.get(0).getOriginal());
                }
                return this.createTemplateLanguageBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, BlockUtil.filterBlocksByRange(childWrappers, node.getTextRange()), settings);
            }
        }
        return this.createTemplateLanguageBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, Collections.emptyList(), settings);
    }

    protected AbstractBlock createDummyBlock(ASTNode node) {
        return new AbstractBlock(node, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), Alignment.createAlignment()){

            @Override
            protected List<Block> buildChildren() {
                return Collections.emptyList();
            }

            public Spacing getSpacing(Block child1, @NotNull Block child2) {
                return Spacing.getReadOnlySpacing();
            }

            public boolean isLeaf() {
                return true;
            }
        };
    }

    @Override
    public boolean dontFormatMyModel() {
        return true;
    }
}

