/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLanguageBlockFragmentWrapper
implements Block {
    private final Block myOwner;
    private final TextRange myRange;

    public DataLanguageBlockFragmentWrapper(@NotNull Block owner, @NotNull TextRange range2) {
        this.myOwner = owner;
        this.myRange = range2;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return AbstractBlock.EMPTY;
    }

    public Wrap getWrap() {
        return this.myOwner.getWrap();
    }

    public Indent getIndent() {
        return this.myOwner.getIndent();
    }

    public Alignment getAlignment() {
        return this.myOwner.getAlignment();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        return Spacing.getReadOnlySpacing();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return this.myOwner.getChildAttributes(newChildIndex);
    }

    public boolean isIncomplete() {
        return this.myOwner.isIncomplete();
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "Fragment " + this.getTextRange();
    }
}

