/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingStateId;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingProgressTask
extends SequentialModalProgressTask
implements FormattingProgressCallback {
    public static final ThreadLocal<Boolean> FORMATTING_CANCELLED_FLAG = ThreadLocal.withInitial(() -> false);
    private static final double MAX_PROGRESS_VALUE = 1.0;
    private static final double TOTAL_WEIGHT = Arrays.stream(FormattingStateId.values()).mapToDouble(FormattingStateId::getProgressWeight).sum();
    private final ConcurrentMap<FormattingProgressCallback.EventType, Collection<Runnable>> myCallbacks = new ConcurrentHashMap<FormattingProgressCallback.EventType, Collection<Runnable>>();
    private final WeakReference<VirtualFile> myFile;
    private final WeakReference<Document> myDocument;
    private final int myFileTextLength;
    @NotNull
    private FormattingStateId myLastState = FormattingStateId.WRAPPING_BLOCKS;
    private long myDocumentModificationStampBefore = -1L;
    private int myBlocksToModifyNumber;
    private int myModifiedBlocksNumber;

    public FormattingProgressTask(@Nullable Project project, @NotNull PsiFile file2, @NotNull Document document) {
        super(project, FormattingProgressTask.getTitle(file2));
        this.myFile = new WeakReference<VirtualFile>(file2.getVirtualFile());
        this.myDocument = new WeakReference<Document>(document);
        this.myFileTextLength = file2.getTextLength();
        this.addCallback(FormattingProgressCallback.EventType.CANCEL, new MyCancelCallback());
    }

    @NotNull
    private static String getTitle(@NotNull PsiFile file2) {
        VirtualFile virtualFile = file2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
        }
        return CodeInsightBundle.message((String)"reformat.progress.file.with.known.name.text", (Object[])new Object[]{virtualFile.getName()});
    }

    @Override
    protected void prepare(@NotNull SequentialTask task2) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            Document document = (Document)this.myDocument.get();
            if (document != null) {
                this.myDocumentModificationStampBefore = document.getModificationStamp();
            }
            task2.prepare();
        });
    }

    @Override
    public boolean addCallback(@NotNull FormattingProgressCallback.EventType eventType, @NotNull Runnable callback2) {
        return this.getCallbacks(eventType).add(callback2);
    }

    public void onSuccess() {
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.SUCCESS)) {
            callback2.run();
        }
    }

    public void onCancel() {
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback2.run();
        }
    }

    public void onThrowable(@NotNull Throwable error) {
        super.onThrowable(error);
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback2.run();
        }
    }

    private Collection<Runnable> getCallbacks(@NotNull FormattingProgressCallback.EventType eventType) {
        Collection<Runnable> candidate;
        Collection<Runnable> result2 = (Collection<Runnable>)this.myCallbacks.get((Object)eventType);
        if (result2 == null && (candidate = this.myCallbacks.putIfAbsent(eventType, result2 = ContainerUtil.newConcurrentSet())) != null) {
            result2 = candidate;
        }
        return result2;
    }

    @Override
    public void afterWrappingBlock(@NotNull LeafBlockWrapper wrapped) {
        this.update(FormattingStateId.WRAPPING_BLOCKS, 1.0 * (double)wrapped.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void afterProcessingBlock(@NotNull LeafBlockWrapper block) {
        this.update(FormattingStateId.PROCESSING_BLOCKS, 1.0 * (double)block.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void beforeApplyingFormatChanges(@NotNull Collection<LeafBlockWrapper> modifiedBlocks) {
        this.myBlocksToModifyNumber = modifiedBlocks.size();
        this.updateTextIfNecessary(FormattingStateId.APPLYING_CHANGES);
        this.setCancelText(IdeBundle.message((String)"action.stop", (Object[])new Object[0]));
    }

    @Override
    public void afterApplyingChange(@NotNull LeafBlockWrapper block) {
        if (this.myModifiedBlocksNumber++ >= this.myBlocksToModifyNumber) {
            return;
        }
        this.update(FormattingStateId.APPLYING_CHANGES, 1.0 * (double)this.myModifiedBlocksNumber / (double)this.myBlocksToModifyNumber);
    }

    private void update(@NotNull FormattingStateId state, double completionRate) {
        double currentFraction;
        ProgressIndicator indicator = this.getIndicator();
        if (indicator == null) {
            return;
        }
        this.updateTextIfNecessary(state);
        this.myLastState = state;
        double newFraction = 0.0;
        for (FormattingStateId prevState : state.getPreviousStates()) {
            newFraction += 1.0 * prevState.getProgressWeight() / TOTAL_WEIGHT;
        }
        if ((newFraction += completionRate * state.getProgressWeight() / TOTAL_WEIGHT) - (currentFraction = indicator.getFraction()) < 0.01) {
            return;
        }
        indicator.setFraction(newFraction);
    }

    private void updateTextIfNecessary(@NotNull FormattingStateId currentState) {
        ProgressIndicator indicator = this.getIndicator();
        if (this.myLastState != currentState && indicator != null) {
            indicator.setText(currentState.getDescription());
        }
    }

    private class MyCancelCallback
    implements Runnable {
        private MyCancelCallback() {
        }

        @Override
        public void run() {
            FORMATTING_CANCELLED_FLAG.set(true);
            VirtualFile file2 = (VirtualFile)FormattingProgressTask.this.myFile.get();
            Document document = (Document)FormattingProgressTask.this.myDocument.get();
            if (file2 == null || document == null || FormattingProgressTask.this.myDocumentModificationStampBefore < 0L) {
                return;
            }
            FileEditor editor = FileEditorManager.getInstance((Project)FormattingProgressTask.this.myProject).getSelectedEditor(file2);
            if (editor == null) {
                return;
            }
            UndoManager manager = UndoManager.getInstance((Project)FormattingProgressTask.this.myProject);
            while (manager.isUndoAvailable(editor) && document.getModificationStamp() != FormattingProgressTask.this.myDocumentModificationStampBefore) {
                manager.undo(editor);
            }
        }
    }
}

