/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.UsageView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShowRecentFindUsagesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        UsageView usageView = (UsageView)e.getData(UsageView.USAGE_VIEW_KEY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (usageView != null && project != null && ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager().getHistory().getAll().size() > 1) {
            e.getPresentation().setEnabled(true);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        UsageView usageView = (UsageView)e.getData(UsageView.USAGE_VIEW_KEY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        ArrayList<ConfigurableUsageTarget> history = new ArrayList<ConfigurableUsageTarget>(findUsagesManager.getHistory().getAll());
        if (!history.isEmpty()) {
            history.remove(history.size() - 1);
            Collections.reverse(history);
        }
        if (history.isEmpty()) {
            history.add(null);
        }
        BaseListPopupStep<ConfigurableUsageTarget> step = new BaseListPopupStep<ConfigurableUsageTarget>(FindBundle.message("recent.find.usages.action.title", new Object[0]), history){

            public Icon getIconFor(ConfigurableUsageTarget data2) {
                return null;
            }

            @NotNull
            public String getTextFor(ConfigurableUsageTarget data2) {
                if (data2 == null) {
                    return FindBundle.message("recent.find.usages.action.nothing", new Object[0]);
                }
                return data2.getLongDescriptiveName();
            }

            public PopupStep onChosen(ConfigurableUsageTarget selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    if (selectedValue != null) {
                        findUsagesManager.rerunAndRecallFromHistory(selectedValue);
                    }
                });
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInCenterOf((Component)usageView.getPreferredFocusableComponent());
    }
}

