/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress;

    public static FindInProjectManager getInstance(Project project) {
        return (FindInProjectManager)ServiceManager.getService((Project)project, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project) {
        this.myProject = project;
    }

    public void findInProject(@NotNull DataContext dataContext, @Nullable FindModel model) {
        FindModel findModel;
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        if (model != null) {
            findModel = model.clone();
        } else {
            findModel = findManager.getFindInProjectModel().clone();
            findModel.setReplaceState(false);
            this.initModel(findModel, dataContext);
        }
        findManager.showFindDialog(findModel, () -> {
            if (findModel.isReplaceState()) {
                ReplaceInProjectManager.getInstance(this.myProject).replaceInPath(findModel);
            } else {
                this.findInPath(findModel);
            }
        });
    }

    public void findInPath(@NotNull FindModel findModel) {
        this.startFindInProject(findModel);
    }

    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext) {
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        String text = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext);
        if (text != null) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)text);
        } else {
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        }
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, presentation2);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager.searchAndShowUsages(new UsageTarget[]{usageTarget}, () -> processor2 -> {
            this.myIsFindInProgress = true;
            try {
                Processor consumer = info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    return processor2.process((Object)usage);
                };
                FindInProjectUtil.findUsages(findModelCopy, this.myProject, (Processor<? super UsageInfo>)consumer, processPresentation);
            }
            finally {
                this.myIsFindInProgress = false;
            }
        }, processPresentation, presentation2, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }
}

