/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindModel;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchToReplace
extends DumbAwareAction
implements LightEditCompatible {
    public SwitchToReplace(@NotNull JComponent shortcutHolder) {
        AnAction replaceAction = ActionManager.getInstance().getAction("Replace");
        if (replaceAction != null) {
            this.registerCustomShortcutSet(replaceAction.getShortcutSet(), shortcutHolder);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        e.getPresentation().setEnabled(editor != null && search2 != null && !ConsoleViewUtil.isConsoleViewEditor(editor));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EditorSearchSession search2 = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        FindModel findModel = search2.getFindModel();
        if (!findModel.isReplaceState()) {
            findModel.setReplaceState(true);
        }
        search2.getComponent().getSearchTextComponent().selectAll();
    }
}

